/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.support.container.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.DependencyMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.test.kernel.deployment.support.container.plugin.GenericComponentInstance;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentBeanMetaDataFactory;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentFactory;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentInstance;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentNameBuilder;
import org.jboss.test.kernel.deployment.support.container.spi.ComponentVisitor;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericComponentFactory<T>
implements ComponentFactory<T>,
ComponentNameBuilder,
KernelControllerContextAware {
    private ComponentBeanMetaDataFactory componentsFactory;
    private AtomicLong compID = new AtomicLong(0L);
    private KernelControllerContext factoryContext;
    private ComponentVisitor visitor;

    public GenericComponentFactory(ComponentBeanMetaDataFactory factory, ComponentVisitor visitor) {
        this.componentsFactory = factory;
        this.visitor = visitor;
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.factoryContext = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.factoryContext = null;
    }

    @Override
    public ComponentInstance<T> createComponents(String baseName) throws Throwable {
        ArrayList<String> compNames = new ArrayList<String>();
        long nextID = this.compID.incrementAndGet();
        KernelController controller = (KernelController)this.factoryContext.getController();
        List<BeanMetaData> compBeans = this.componentsFactory.getBeans(baseName, nextID, this, this.visitor);
        Object t = null;
        for (BeanMetaData bmd : compBeans) {
            String beanName = bmd.getName();
            KernelControllerContext kcc = controller.install(bmd);
            if (t == null) {
                t = kcc.getTarget();
            }
            compNames.add(beanName);
        }
        GenericComponentInstance<Object> instance = new GenericComponentInstance<Object>(t, (List<String>)compNames, nextID);
        return instance;
    }

    @Override
    public void destroyComponents(ComponentInstance<T> instance) throws Exception {
        KernelController controller = (KernelController)this.factoryContext.getController();
        List<String> compBeans = instance.getComponentNames();
        for (String beanName : compBeans) {
            controller.uninstall((Object)beanName);
        }
    }

    @Override
    public long getComponentID(String name) throws NumberFormatException {
        int poundSign = name.lastIndexOf(35);
        if (poundSign < 0) {
            throw new NumberFormatException(name + " has no #compID suffix");
        }
        long id = Long.parseLong(name.substring(poundSign + 1));
        return id;
    }

    @Override
    public String buildName(String baseName, String compName, long compID) {
        String beanName = baseName + "@" + compName + "#" + compID;
        return beanName;
    }

    @Override
    public ComponentBeanMetaDataFactory getFactory() {
        return this.componentsFactory;
    }

    public void validate() {
        KernelController controller = (KernelController)this.factoryContext.getController();
        Set notInstalled = controller.getNotInstalled();
        if (notInstalled.size() != 0) {
            throw new IllegalStateException(notInstalled.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BeanMetaDataName
    implements BeanMetaData {
        BeanMetaData bmd;
        String name;

        BeanMetaDataName(String name, BeanMetaData bmd) {
            this.name = name;
            this.bmd = bmd;
        }

        public Object clone() {
            return this.bmd.clone();
        }

        public void describeVisit(MetaDataVisitor vistor) {
            this.bmd.describeVisit(vistor);
        }

        public BeanAccessMode getAccessMode() {
            return this.bmd.getAccessMode();
        }

        public Set<Object> getAliases() {
            return this.bmd.getAliases();
        }

        public Set<AnnotationMetaData> getAnnotations() {
            return this.bmd.getAnnotations();
        }

        public AutowireType getAutowireType() {
            return this.bmd.getAutowireType();
        }

        public String getBean() {
            return this.bmd.getBean();
        }

        public Iterator<? extends MetaDataVisitorNode> getChildren() {
            return this.bmd.getChildren();
        }

        public ClassLoaderMetaData getClassLoader() {
            return this.bmd.getClassLoader();
        }

        public ConstructorMetaData getConstructor() {
            return this.bmd.getConstructor();
        }

        public LifecycleMetaData getCreate() {
            return this.bmd.getCreate();
        }

        public Set<DemandMetaData> getDemands() {
            return this.bmd.getDemands();
        }

        public Set<DependencyMetaData> getDepends() {
            return this.bmd.getDepends();
        }

        public String getDescription() {
            return this.bmd.getDescription();
        }

        public LifecycleMetaData getDestroy() {
            return this.bmd.getDestroy();
        }

        public ErrorHandlingMode getErrorHandlingMode() {
            return this.bmd.getErrorHandlingMode();
        }

        public List<CallbackMetaData> getInstallCallbacks() {
            return this.bmd.getInstallCallbacks();
        }

        public List<InstallMetaData> getInstalls() {
            return this.bmd.getInstalls();
        }

        public ControllerMode getMode() {
            return this.bmd.getMode();
        }

        public String getName() {
            return this.name;
        }

        public String getParent() {
            return this.bmd.getParent();
        }

        public Set<PropertyMetaData> getProperties() {
            return this.bmd.getProperties();
        }

        public LifecycleMetaData getStart() {
            return this.bmd.getStart();
        }

        public LifecycleMetaData getStop() {
            return this.bmd.getStop();
        }

        public Set<SupplyMetaData> getSupplies() {
            return this.bmd.getSupplies();
        }

        public Object getUnderlyingValue() {
            return this.bmd.getUnderlyingValue();
        }

        public List<CallbackMetaData> getUninstallCallbacks() {
            return this.bmd.getUninstallCallbacks();
        }

        public List<InstallMetaData> getUninstalls() {
            return this.bmd.getUninstalls();
        }

        public Object getValue(TypeInfo info, ClassLoader cl) throws Throwable {
            return this.bmd.getValue(info, cl);
        }

        public void initialVisit(MetaDataVisitor vistor) {
            this.bmd.initialVisit(vistor);
        }

        public boolean isAbstract() {
            return this.bmd.isAbstract();
        }

        public boolean isAutowireCandidate() {
            return this.bmd.isAutowireCandidate();
        }

        public void setAnnotations(Set<AnnotationMetaData> annotations) {
            this.bmd.setAnnotations(annotations);
        }

        public void setClassLoader(ClassLoaderMetaData classLoader) {
            this.bmd.setClassLoader(classLoader);
        }

        public void setMode(ControllerMode mode) {
            this.bmd.setMode(mode);
        }

        public void setName(String name) {
            this.bmd.setName(name);
        }

        public String toShortString() {
            return this.bmd.toShortString();
        }

        public void toShortString(JBossStringBuilder arg0) {
            this.bmd.toShortString(arg0);
        }
    }
}

