/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.metadata.test;

import junit.framework.Test;
import org.jboss.dependency.spi.ScopeInfo;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.kernel.metadata.support.TestAnnotationA;
import org.jboss.test.kernel.metadata.support.TestAnnotationB;
import org.jboss.test.kernel.metadata.support.TestAnnotationC;
import org.jboss.test.kernel.metadata.test.AbstractMetaDataTest;

public class ClassAnnotationTestCase
extends AbstractMetaDataTest {
    public static Test suite() {
        return ClassAnnotationTestCase.suite(ClassAnnotationTestCase.class);
    }

    public ClassAnnotationTestCase(String name) throws Throwable {
        super(name);
    }

    protected MetaData assertMetaData() {
        return this.assertMetaData("Name1");
    }

    protected MetaData assertMetaData(String name) {
        KernelControllerContext context = this.getControllerContext(name);
        ClassAnnotationTestCase.assertNotNull((Object)context);
        ScopeInfo scopeInfo = context.getScopeInfo();
        ClassAnnotationTestCase.assertNotNull((Object)scopeInfo);
        MetaData metaData = scopeInfo.getMetaData();
        ClassAnnotationTestCase.assertNotNull((Object)metaData);
        return metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassAnnotationNoOverride() throws Throwable {
        ScopeKey scope = null;
        KernelDeployment deployment = this.deploy("ClassAnnotationTestCase_NoOverride.xml");
        try {
            scope = this.assertRetrievals("Name1");
            MetaData metaData = this.assertMetaData();
            TestAnnotationA a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)a.value());
            TestAnnotationB b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertNoAnnotation(metaData, TestAnnotationC.class);
        }
        finally {
            this.undeploy(deployment);
            if (scope != null) {
                this.assertNoRetrievals("Name1", scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassAnnotationOverride() throws Throwable {
        ScopeKey scope = null;
        KernelDeployment deployment = this.deploy("ClassAnnotationTestCase_Override.xml");
        try {
            scope = this.assertRetrievals("Name1");
            MetaData metaData = this.assertMetaData();
            TestAnnotationA a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"Overridden", (String)a.value());
            TestAnnotationB b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertNoAnnotation(metaData, TestAnnotationC.class);
        }
        finally {
            this.undeploy(deployment);
            if (scope != null) {
                this.assertNoRetrievals("Name1", scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassAnnotationNew() throws Throwable {
        ScopeKey scope = null;
        KernelDeployment deployment = this.deploy("ClassAnnotationTestCase_New.xml");
        try {
            scope = this.assertRetrievals("Name1");
            MetaData metaData = this.assertMetaData();
            TestAnnotationA a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)a.value());
            TestAnnotationB b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertAnnotation(metaData, TestAnnotationC.class);
        }
        finally {
            this.undeploy(deployment);
            if (scope != null) {
                this.assertNoRetrievals("Name1", scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertyAnnotationNoOverride() throws Throwable {
        ScopeKey scope = null;
        KernelDeployment deployment = this.deploy("ClassAnnotationTestCase_NoOverrideProperty.xml");
        try {
            scope = this.assertRetrievals("Name1");
            MetaData classMetaData = this.assertMetaData();
            MetaData metaData = classMetaData.getComponentMetaData((Signature)new MethodSignature("getSomething", new Class[0]));
            TestAnnotationA a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)a.value());
            TestAnnotationB b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertNoAnnotation(metaData, TestAnnotationC.class);
            metaData = classMetaData.getComponentMetaData((Signature)new MethodSignature("setSomething", new Class[]{String.class}));
            a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)a.value());
            b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertNoAnnotation(metaData, TestAnnotationC.class);
        }
        finally {
            this.undeploy(deployment);
            if (scope != null) {
                this.assertNoRetrievals("Name1", scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertyAnnotationOverride() throws Throwable {
        ScopeKey scope = null;
        KernelDeployment deployment = this.deploy("ClassAnnotationTestCase_OverrideProperty.xml");
        try {
            scope = this.assertRetrievals("Name1");
            MetaData classMetaData = this.assertMetaData();
            MetaData metaData = classMetaData.getComponentMetaData((Signature)new MethodSignature("getSomething", new Class[0]));
            TestAnnotationA a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"Overridden", (String)a.value());
            TestAnnotationB b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertNoAnnotation(metaData, TestAnnotationC.class);
            metaData = classMetaData.getComponentMetaData((Signature)new MethodSignature("setSomething", new Class[]{String.class}));
            a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"Overridden", (String)a.value());
            b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertNoAnnotation(metaData, TestAnnotationC.class);
        }
        finally {
            this.undeploy(deployment);
            if (scope != null) {
                this.assertNoRetrievals("Name1", scope);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPropertyAnnotationNew() throws Throwable {
        ScopeKey scope = null;
        KernelDeployment deployment = this.deploy("ClassAnnotationTestCase_NewProperty.xml");
        try {
            scope = this.assertRetrievals("Name1");
            MetaData classMetaData = this.assertMetaData();
            MetaData metaData = classMetaData.getComponentMetaData((Signature)new MethodSignature("getSomething", new Class[0]));
            TestAnnotationA a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)a.value());
            TestAnnotationB b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertAnnotation(metaData, TestAnnotationC.class);
            metaData = classMetaData.getComponentMetaData((Signature)new MethodSignature("setSomething", new Class[]{String.class}));
            a = this.assertAnnotation(metaData, TestAnnotationA.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)a.value());
            b = this.assertAnnotation(metaData, TestAnnotationB.class);
            ClassAnnotationTestCase.assertEquals((String)"NotOverridden", (String)b.value());
            this.assertAnnotation(metaData, TestAnnotationC.class);
        }
        finally {
            this.undeploy(deployment);
            if (scope != null) {
                this.assertNoRetrievals("Name1", scope);
            }
        }
    }
}

