/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.annotations;

import org.jboss.beans.metadata.plugins.annotations.Inject;
import org.jboss.beans.metadata.plugins.annotations.JavaBeanValue;
import org.jboss.beans.metadata.plugins.annotations.NullValue;
import org.jboss.beans.metadata.plugins.annotations.Parameter;
import org.jboss.beans.metadata.plugins.annotations.StringValue;
import org.jboss.beans.metadata.plugins.annotations.ThisValue;
import org.jboss.beans.metadata.plugins.annotations.Value;
import org.jboss.beans.metadata.plugins.annotations.ValueFactory;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.annotations.InjectAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.JavaBeanValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.NullValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.StringValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ThisValueAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.ValueFactoryAnnotationPlugin;

final class ValueUtil {
    ValueUtil() {
    }

    private static void checkValueMetaData(ValueMetaData value) {
        if (value != null) {
            throw new IllegalArgumentException("@Value/@Parameter annotation has too many values set!");
        }
    }

    static boolean isAttributePresent(String value) {
        return value != null && value.length() > 0;
    }

    static ValueMetaData createValueMetaData(Value value) {
        JavaBeanValue javabean;
        NullValue nullValue;
        ThisValue thisValue;
        ValueFactory vf;
        Inject inject;
        ValueMetaData vmd = null;
        StringValue string = value.string();
        if (ValueUtil.isAttributePresent(string.value())) {
            vmd = StringValueAnnotationPlugin.INSTANCE.createValueMetaData(string);
        }
        if ((inject = value.inject()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = InjectAnnotationPlugin.INSTANCE.createValueMetaData(inject);
        }
        if (ValueUtil.isAttributePresent((vf = value.valueFactory()).bean())) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = ValueFactoryAnnotationPlugin.INSTANCE.createValueMetaData(vf);
        }
        if ((thisValue = value.thisValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = ThisValueAnnotationPlugin.INSTANCE.createValueMetaData(thisValue);
        }
        if ((nullValue = value.nullValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = NullValueAnnotationPlugin.INSTANCE.createValueMetaData(nullValue);
        }
        if (ValueUtil.isAttributePresent((javabean = value.javabean()).value())) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = JavaBeanValueAnnotationPlugin.INSTANCE.createValueMetaData(javabean);
        }
        if (vmd == null) {
            throw new IllegalArgumentException("No value set on @Value annotation!");
        }
        return vmd;
    }

    static ValueMetaData createValueMetaData(Parameter parameter) {
        JavaBeanValue javabean;
        NullValue nullValue;
        ThisValue thisValue;
        Inject inject;
        ValueMetaData vmd = null;
        StringValue string = parameter.string();
        if (ValueUtil.isAttributePresent(string.value())) {
            vmd = StringValueAnnotationPlugin.INSTANCE.createValueMetaData(string);
        }
        if ((inject = parameter.inject()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = InjectAnnotationPlugin.INSTANCE.createValueMetaData(inject);
        }
        if ((thisValue = parameter.thisValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = ThisValueAnnotationPlugin.INSTANCE.createValueMetaData(thisValue);
        }
        if ((nullValue = parameter.nullValue()).valid()) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = NullValueAnnotationPlugin.INSTANCE.createValueMetaData(nullValue);
        }
        if (ValueUtil.isAttributePresent((javabean = parameter.javabean()).value())) {
            ValueUtil.checkValueMetaData(vmd);
            vmd = JavaBeanValueAnnotationPlugin.INSTANCE.createValueMetaData(javabean);
        }
        if (vmd == null) {
            throw new IllegalArgumentException("No value set on @Value annotation!");
        }
        return vmd;
    }
}

