/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.InstallMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class InstallTestCase
extends AbstractXMLTest {
    protected InstallMetaData getInstall(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        List installs = bean.getInstalls();
        InstallTestCase.assertNotNull((Object)installs);
        InstallTestCase.assertEquals((int)1, (int)installs.size());
        InstallMetaData install = (InstallMetaData)installs.get(0);
        InstallTestCase.assertNotNull((Object)install);
        return install;
    }

    public void testInstallWithBean() throws Exception {
        InstallMetaData install = this.getInstall("InstallWithBean.xml");
        InstallTestCase.assertEquals((String)"Bean", (String)install.getBean());
        InstallTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallTestCase.assertNull((Object)install.getAnnotations());
        InstallTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithState() throws Exception {
        InstallMetaData install = this.getInstall("InstallWithState.xml");
        InstallTestCase.assertNull((Object)install.getBean());
        InstallTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)install.getDependentState());
        InstallTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallTestCase.assertNull((Object)install.getAnnotations());
        InstallTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithMethod() throws Exception {
        InstallMetaData install = this.getInstall("InstallWithMethod.xml");
        InstallTestCase.assertNull((Object)install.getBean());
        InstallTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallTestCase.assertEquals((String)"Method", (String)install.getMethodName());
        InstallTestCase.assertNull((Object)install.getAnnotations());
        InstallTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithAnnotation() throws Exception {
        InstallMetaData install = this.getInstall("InstallWithAnnotation.xml");
        InstallTestCase.assertNull((Object)install.getBean());
        InstallTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        this.assertAnnotations(expected, install.getAnnotations());
        InstallTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithAnnotations() throws Exception {
        InstallMetaData install = this.getInstall("InstallWithAnnotations.xml");
        InstallTestCase.assertNull((Object)install.getBean());
        InstallTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation1");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation2");
        expected.add("org.jboss.test.kernel.deployment.xml.support.Annotation3");
        this.assertAnnotations(expected, install.getAnnotations());
        InstallTestCase.assertNull((Object)install.getParameters());
    }

    public void testInstallWithParameter() throws Exception {
        InstallMetaData install = this.getInstall("InstallWithParameter.xml");
        InstallTestCase.assertNull((Object)install.getBean());
        InstallTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallTestCase.assertNull((Object)install.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        this.assertParameters(expected, install.getParameters());
    }

    public void testInstallWithParameters() throws Exception {
        InstallMetaData install = this.getInstall("InstallWithParameters.xml");
        InstallTestCase.assertNull((Object)install.getBean());
        InstallTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)install.getDependentState());
        InstallTestCase.assertEquals((String)"Dummy", (String)install.getMethodName());
        InstallTestCase.assertNull((Object)install.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        expected.add("Parameter2");
        expected.add("Parameter3");
        this.assertParameters(expected, install.getParameters());
    }

    public void testInstallBadNoMethod() throws Exception {
        try {
            this.unmarshalBean("InstallBadNoMethod.xml");
            InstallTestCase.fail((String)"Should not be here");
        }
        catch (Exception expected) {
            this.checkJBossXBException(IllegalArgumentException.class, expected);
        }
    }

    public static Test suite() {
        return InstallTestCase.suite(InstallTestCase.class);
    }

    public InstallTestCase(String name) {
        super(name);
    }
}

