/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.registry.test;

import junit.framework.Test;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.joinpoint.spi.JoinpointFactory;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.test.kernel.AbstractKernelTest;

public class BusTestCase
extends AbstractKernelTest {
    public static Test suite() {
        return BusTestCase.suite(BusTestCase.class);
    }

    public BusTestCase(String name) {
        super(name);
    }

    public void testInvoke() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelConfig config = kernel.getConfig();
        registry.registerEntry((Object)"Name1", BusTestCase.makeEntry("A string"));
        registry.registerEntry((Object)"Name2", BusTestCase.makeEntry("B string"));
        KernelBus bus = kernel.getBus();
        MethodJoinpoint joinPoint = this.getMethodJoinpoint(config, String.class, "toString");
        Object result1 = bus.invoke((Object)"Name1", (TargettedJoinpoint)joinPoint);
        Object result2 = bus.invoke((Object)"Name2", (TargettedJoinpoint)joinPoint);
        BusTestCase.assertEquals((Object)"A string", (Object)result1);
        BusTestCase.assertEquals((Object)"B string", (Object)result2);
    }

    protected MethodJoinpoint getMethodJoinpoint(KernelConfig config, Class clazz, String string) throws Throwable {
        BeanInfo info = config.getBeanInfo(clazz);
        JoinpointFactory jpf = info.getJoinpointFactory();
        return Config.getMethodJoinpoint(null, (JoinpointFactory)jpf, (String)string, null, null);
    }
}

