/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.test;

import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.MutableMetaData;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.test.kernel.deployment.support.NameAwareBean;
import org.jboss.test.kernel.deployment.test.AbstractDeploymentTest;

public class FromContextUnsupportedTestCase
extends AbstractDeploymentTest {
    public FromContextUnsupportedTestCase(String name) throws Throwable {
        super(name);
    }

    public static Test suite() {
        return FromContextUnsupportedTestCase.suite(FromContextUnsupportedTestCase.class);
    }

    public void testUnsupportedInjection() throws Throwable {
        NameAwareBean alias = (NameAwareBean)this.getBean("aliases");
        FromContextUnsupportedTestCase.assertNotNull((Object)alias);
        Set<Object> aliases = alias.getAliases();
        FromContextUnsupportedTestCase.assertNotNull(aliases);
        FromContextUnsupportedTestCase.assertFalse((boolean)aliases.isEmpty());
        FromContextUnsupportedTestCase.assertTrue((boolean)aliases.contains("a1"));
        FromContextUnsupportedTestCase.assertTrue((boolean)aliases.contains("a2"));
        FromContextUnsupportedTestCase.assertTrue((boolean)aliases.contains("a3"));
        try {
            aliases.add("failedAlias");
        }
        catch (Throwable t) {
            this.assertUnsupported(t);
        }
        NameAwareBean metadata = (NameAwareBean)this.getBean("metadata");
        FromContextUnsupportedTestCase.assertNotNull((Object)metadata);
        MetaData md = metadata.getMetadata();
        FromContextUnsupportedTestCase.assertNotNull((Object)md);
        FromContextUnsupportedTestCase.assertFalse((boolean)(md instanceof MutableMetaData));
        NameAwareBean beaninfo = (NameAwareBean)this.getBean("beaninfo");
        FromContextUnsupportedTestCase.assertNotNull((Object)beaninfo);
        BeanInfo info = beaninfo.getBeaninfo();
        FromContextUnsupportedTestCase.assertNotNull((Object)info);
        try {
            info.setMethods(new HashSet());
        }
        catch (Throwable t) {
            this.assertUnsupported(t);
        }
        NameAwareBean scopekey = (NameAwareBean)this.getBean("scopekey");
        FromContextUnsupportedTestCase.assertNotNull((Object)scopekey);
        ScopeKey key = scopekey.getScopeKey();
        FromContextUnsupportedTestCase.assertNotNull((Object)key);
        this.assertInstanceOf(key, ScopeKey.class);
        KernelControllerContext context = this.getControllerContext("scopekey");
        FromContextUnsupportedTestCase.assertEquals((Object)key, (Object)context.getScopeInfo().getScope());
        NameAwareBean dynamic = (NameAwareBean)this.getBean("dynamic");
        FromContextUnsupportedTestCase.assertNotNull((Object)dynamic);
        Object dyna = dynamic.getDynamic();
        FromContextUnsupportedTestCase.assertNotNull((Object)dyna);
        this.assertInstanceOf(dyna, BeanMetaData.class);
        BeanMetaData bmd = (BeanMetaData)dyna;
        try {
            bmd.setName("failedName");
        }
        catch (Throwable t) {
            this.assertUnsupported(t);
        }
        NameAwareBean ctx = (NameAwareBean)this.getBean("context");
        FromContextUnsupportedTestCase.assertNotNull((Object)ctx);
        ControllerContext realCtx = ctx.getContext();
        FromContextUnsupportedTestCase.assertNotNull((Object)realCtx);
        try {
            realCtx.setMode(ControllerMode.DISABLED);
        }
        catch (Throwable t) {
            this.assertUnsupported(t);
        }
        DependencyInfo dependencyInfo = realCtx.getDependencyInfo();
        FromContextUnsupportedTestCase.assertNotNull((Object)dependencyInfo);
        try {
            dependencyInfo.addIDependOn((DependencyItem)new AbstractDependencyItem());
        }
        catch (Throwable t) {
            this.assertUnsupported(t);
        }
    }

    protected void assertUnsupported(Throwable t) {
        this.assertInstanceOf(t, UnsupportedOperationException.class);
    }
}

