/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.helpers.UnmodifiableBeanInfo;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.helpers.UnmodifiableControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.helpers.UnmodifiableKernelControllerContext;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromContext<T extends ControllerContext>
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final FromContext NAME = new NameFromContext("name");
    public static final FromContext ALIASES = new AliasesFromContext("aliases");
    public static final FromContext METADATA = new MetaDataFromContext("metadata");
    public static final FromContext BEANINFO = new BeanInfoFromContext("beaninfo");
    public static final FromContext SCOPE = new ScopeFromContext("scope");
    public static final FromContext ID = new IdFromContext("id");
    public static final FromContext CONTEXT = new ThisContext("context");
    protected final String fromString;

    protected FromContext(String fromString) {
        if (fromString == null) {
            throw new IllegalArgumentException("Null from string");
        }
        this.fromString = fromString;
    }

    public static FromContext getInstance(String fromString) {
        if (NAME.getFromString().equalsIgnoreCase(fromString)) {
            return NAME;
        }
        if (ALIASES.getFromString().equalsIgnoreCase(fromString)) {
            return ALIASES;
        }
        if (METADATA.getFromString().equalsIgnoreCase(fromString)) {
            return METADATA;
        }
        if (BEANINFO.getFromString().equalsIgnoreCase(fromString)) {
            return BEANINFO;
        }
        if (SCOPE.getFromString().equalsIgnoreCase(fromString)) {
            return SCOPE;
        }
        if (ID.getFromString().equalsIgnoreCase(fromString)) {
            return ID;
        }
        if (CONTEXT.getFromString().equalsIgnoreCase(fromString)) {
            return CONTEXT;
        }
        return new DynamicFromContext(fromString);
    }

    protected void validate(ControllerContext context) {
    }

    public Object executeLookup(ControllerContext context) throws Throwable {
        this.validate(context);
        return this.internalExecute(context);
    }

    public abstract Object internalExecute(T var1) throws Throwable;

    public String getFromString() {
        return this.fromString;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FromContext)) {
            return false;
        }
        FromContext other = (FromContext)object;
        return this.fromString.equals(other.getFromString());
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append(this.fromString);
    }

    protected int getHashCode() {
        return this.fromString.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DynamicFromContext
    extends FromContext {
        private static final long serialVersionUID = 1L;

        public DynamicFromContext(String fromString) {
            super(fromString);
        }

        protected Method findMethod(Class clazz) {
            Method[] methods;
            if (clazz == null || clazz == Object.class) {
                return null;
            }
            for (Method m : methods = clazz.getDeclaredMethods()) {
                if (!m.getName().equals(this.getFromString()) || m.getParameterTypes().length != 0) continue;
                return m;
            }
            Method method = this.findMethod(clazz.getSuperclass());
            if (method != null) {
                return method;
            }
            for (Class<?> infc : clazz.getInterfaces()) {
                Method m = this.findMethod(infc);
                if (m == null) continue;
                return m;
            }
            return null;
        }

        protected void getInterfaces(Class clazz, Set<Class> interfaces) {
            if (clazz == Object.class || clazz == null) {
                return;
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                interfaces.add(iface);
            }
            this.getInterfaces(clazz.getSuperclass(), interfaces);
        }

        public Object internalExecute(ControllerContext context) throws Throwable {
            Method method = this.findMethod(context.getClass());
            if (method == null) {
                throw new IllegalArgumentException("No such getter on context class or mistyped fromContext string: " + this.getFromString());
            }
            Object result = ReflectionUtils.invoke((Method)method, (Object)context, (Object[])new Object[0]);
            if (result != null) {
                HashSet<Class> interfaces = new HashSet<Class>();
                this.getInterfaces(result.getClass(), interfaces);
                return Proxy.newProxyInstance(ControllerContext.class.getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new DynamicWrapper(result));
            }
            return null;
        }

        private class DynamicWrapper
        implements InvocationHandler {
            private Object target;

            public DynamicWrapper(Object target) {
                this.target = target;
            }

            protected boolean isUnsupported(Method method) {
                String name = method.getName();
                return name.startsWith("set") || name.startsWith("add");
            }

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.isUnsupported(method)) {
                    throw new UnsupportedOperationException();
                }
                return ReflectionUtils.invoke((Method)method, (Object)this.target, (Object[])args);
            }
        }
    }

    private static class ThisContext
    extends FromContext {
        private static final long serialVersionUID = 1L;

        public ThisContext(String fromString) {
            super(fromString);
        }

        public ControllerContext internalExecute(ControllerContext context) {
            if (context instanceof KernelControllerContext) {
                return new UnmodifiableKernelControllerContext((KernelControllerContext)context);
            }
            return new UnmodifiableControllerContext(context);
        }
    }

    private static class IdFromContext
    extends FromContext {
        private static final long serialVersionUID = 1L;

        public IdFromContext(String fromString) {
            super(fromString);
        }

        public Object internalExecute(ControllerContext context) {
            return context.getName();
        }
    }

    private static class ScopeFromContext
    extends KernelFromContext {
        private static final long serialVersionUID = 1L;

        public ScopeFromContext(String fromString) {
            super(fromString);
        }

        public ScopeKey internalExecute(KernelControllerContext context) {
            return context.getScopeInfo().getScope();
        }
    }

    private static class BeanInfoFromContext
    extends KernelFromContext {
        private static final long serialVersionUID = 1L;

        public BeanInfoFromContext(String fromString) {
            super(fromString);
        }

        public BeanInfo internalExecute(KernelControllerContext context) {
            BeanInfo info = context.getBeanInfo();
            return info != null ? new UnmodifiableBeanInfo(info) : null;
        }
    }

    private static class MetaDataFromContext
    extends KernelFromContext {
        private static final long serialVersionUID = 1L;

        public MetaDataFromContext(String fromString) {
            super(fromString);
        }

        public MetaData internalExecute(KernelControllerContext context) {
            return context.getScopeInfo().getMetaData();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AliasesFromContext
    extends FromContext {
        private static final long serialVersionUID = 1L;

        public AliasesFromContext(String fromString) {
            super(fromString);
        }

        public Set<Object> internalExecute(ControllerContext context) {
            Set aliases = context.getAliases();
            return aliases != null ? Collections.unmodifiableSet(aliases) : null;
        }
    }

    private static class NameFromContext
    extends FromContext {
        private static final long serialVersionUID = 1L;

        public NameFromContext(String fromString) {
            super(fromString);
        }

        public Object internalExecute(ControllerContext context) {
            return context.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class KernelFromContext
    extends FromContext<KernelControllerContext> {
        private static final long serialVersionUID = 1L;

        protected KernelFromContext(String fromString) {
            super(fromString);
        }

        @Override
        protected void validate(ControllerContext context) {
            if (!(context instanceof KernelControllerContext)) {
                throw new UnsupportedOperationException("Cannot execute " + this.getFromString() + " on underlying context: " + context);
            }
        }
    }
}

