/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.test;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.deployment.support.AliasesImpl;
import org.jboss.test.kernel.deployment.support.ApplicationScopeImpl;
import org.jboss.test.kernel.deployment.support.SimpleBeanImpl;
import org.jboss.test.kernel.deployment.support.SimpleObjectWithBean;
import org.jboss.test.kernel.deployment.test.ScopingDeploymentTest;

public class ScopingDependencyTestCase
extends ScopingDeploymentTest {
    private static final String PARENT_CLASS = SimpleBeanImpl.class.getName();
    private static final String CHILD_CLASS = SimpleObjectWithBean.class.getName();
    private static final String PARENT = "Parent";
    private static final String CHILD = "Child";
    private static final String SCOPED_PARENT = "Scoped_Parent";
    private static final String APP_SCOPE_1 = "scoped1";
    private static final String APP_SCOPE_2 = "scoped2";

    public ScopingDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public static Test suite() {
        return ScopingDependencyTestCase.suite(ScopingDependencyTestCase.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScopedChildDependencyOnParent() throws Throwable {
        KernelDeployment childDeployment = this.createChildDeployment(CHILD, PARENT, APP_SCOPE_1, null);
        this.deploy(childDeployment);
        try {
            this.assertNoSuchContext(CHILD);
            KernelDeployment parentDeployment = this.createParentDeployment();
            this.deploy(parentDeployment);
            try {
                KernelControllerContext parent = this.getControllerContext(PARENT);
                KernelControllerContext child = this.getControllerContext(CHILD);
                ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)child.getController());
            }
            finally {
                this.undeploy(parentDeployment);
            }
            this.assertNoSuchContext(PARENT);
            this.assertNoSuchContext(CHILD);
        }
        finally {
            this.undeploy(childDeployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScopedChildWithDependencyOnAliasInScopedControllerWithSameNameAsParent() throws Throwable {
        KernelDeployment childDeployment = this.createChildDeployment(CHILD, PARENT, APP_SCOPE_1, null);
        this.deploy(childDeployment);
        try {
            this.assertNoSuchContext(CHILD);
            KernelDeployment parentInChildScopeDeployment = this.createDeployment(SCOPED_PARENT, PARENT_CLASS, null, APP_SCOPE_1, PARENT);
            this.deploy(parentInChildScopeDeployment);
            try {
                KernelControllerContext scopedParent = this.getControllerContext(SCOPED_PARENT);
                KernelControllerContext child = this.getControllerContext(CHILD);
                ScopingDependencyTestCase.assertSame((Object)scopedParent.getController(), (Object)child.getController());
                KernelDeployment parentDeployment = this.createParentDeployment();
                this.deploy(parentDeployment);
                try {
                    KernelControllerContext parent = this.getControllerContext(PARENT);
                    ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)child.getController());
                }
                finally {
                    this.undeploy(parentDeployment);
                }
                scopedParent = this.getControllerContext(SCOPED_PARENT);
                child = this.getControllerContext(CHILD);
            }
            finally {
                this.undeploy(parentInChildScopeDeployment);
            }
            this.assertNoSuchContext(CHILD);
        }
        finally {
            this.undeploy(childDeployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScopedChildWithNoDependencyAndGlobalChildWithDependencyOnParent() throws Throwable {
        KernelDeployment childDeploymentNoDependencies = this.createChildDeployment(CHILD, null, APP_SCOPE_2, null);
        this.deploy(childDeploymentNoDependencies);
        try {
            List contextsNoDependencies = childDeploymentNoDependencies.getInstalledContexts();
            ScopingDependencyTestCase.assertEquals((int)1, (int)contextsNoDependencies.size());
            KernelControllerContext childNoDependencies = (KernelControllerContext)contextsNoDependencies.get(0);
            ScopingDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)childNoDependencies.getState());
            KernelDeployment childDeploymentWithDependencies = this.createChildDeployment("Child1", CHILD, PARENT, APP_SCOPE_1, null);
            this.deploy(childDeploymentWithDependencies);
            try {
                List contextsWithDependencies = childDeploymentWithDependencies.getInstalledContexts();
                ScopingDependencyTestCase.assertEquals((int)1, (int)contextsWithDependencies.size());
                KernelControllerContext childWithDependencies = (KernelControllerContext)contextsWithDependencies.get(0);
                ScopingDependencyTestCase.assertFalse((boolean)ControllerState.INSTALLED.equals((Object)childWithDependencies.getState()));
                ScopingDependencyTestCase.assertNotSame((Object)childNoDependencies.getController(), (Object)childWithDependencies.getController());
                KernelDeployment parentDeployment = this.createParentDeployment();
                this.deploy(parentDeployment);
                try {
                    KernelControllerContext parent = this.getControllerContext(PARENT);
                    KernelControllerContext child = this.getControllerContext(CHILD);
                    ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)child.getController());
                    ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)childNoDependencies.getController());
                    ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)childWithDependencies.getController());
                    ScopingDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)childNoDependencies.getState());
                }
                finally {
                    this.undeploy(parentDeployment);
                }
                this.assertNoSuchContext(PARENT);
                ScopingDependencyTestCase.assertFalse((boolean)ControllerState.INSTALLED.equals((Object)childWithDependencies.getState()));
                ScopingDependencyTestCase.assertFalse((boolean)ControllerState.INSTALLED.equals((Object)childNoDependencies.getState()));
            }
            finally {
                this.undeploy(childDeploymentWithDependencies);
            }
        }
        finally {
            this.undeploy(childDeploymentNoDependencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testScopedChildWithNoDependencyAndGlobalChildWithDependencyOnParentViaAliases() throws Throwable {
        KernelDeployment childDeploymentNoDependencies = this.createChildDeployment("Child1", null, APP_SCOPE_2, CHILD);
        this.deploy(childDeploymentNoDependencies);
        try {
            List contextsNoDependencies = childDeploymentNoDependencies.getInstalledContexts();
            ScopingDependencyTestCase.assertEquals((int)1, (int)contextsNoDependencies.size());
            KernelControllerContext childNoDependencies = (KernelControllerContext)contextsNoDependencies.get(0);
            ScopingDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)childNoDependencies.getState());
            KernelDeployment childDeploymentWithDependencies = this.createChildDeployment("Child2", "Child2", PARENT, APP_SCOPE_1, CHILD);
            this.deploy(childDeploymentWithDependencies);
            try {
                List contextsWithDependencies = childDeploymentWithDependencies.getInstalledContexts();
                ScopingDependencyTestCase.assertEquals((int)1, (int)contextsWithDependencies.size());
                KernelControllerContext childWithDependencies = (KernelControllerContext)contextsWithDependencies.get(0);
                ScopingDependencyTestCase.assertFalse((boolean)ControllerState.INSTALLED.equals((Object)childWithDependencies.getState()));
                ScopingDependencyTestCase.assertNotSame((Object)childNoDependencies.getController(), (Object)childWithDependencies.getController());
                KernelDeployment parentDeployment = this.createParentDeployment();
                this.deploy(parentDeployment);
                try {
                    KernelControllerContext parent = this.getControllerContext(PARENT);
                    KernelControllerContext child = this.getControllerContext(CHILD);
                    ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)child.getController());
                    ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)childNoDependencies.getController());
                    ScopingDependencyTestCase.assertNotSame((Object)parent.getController(), (Object)childWithDependencies.getController());
                    ScopingDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)childNoDependencies.getState());
                }
                finally {
                    this.undeploy(parentDeployment);
                }
                this.assertNoSuchContext(PARENT);
                ScopingDependencyTestCase.assertFalse((boolean)ControllerState.INSTALLED.equals((Object)childWithDependencies.getState()));
                ScopingDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)childNoDependencies.getState());
            }
            finally {
                this.undeploy(childDeploymentWithDependencies);
            }
        }
        finally {
            this.undeploy(childDeploymentNoDependencies);
        }
    }

    public void testTwoScopedChildrenOneWithDependencyOnParent() throws Throwable {
        this.runTestTwoScopedChildrenWithDependencyOnParent(false);
    }

    public void testTwoScopedChildrenOneWithDependencyOnParentReverseOrder() throws Throwable {
        this.runTestTwoScopedChildrenWithDependencyOnParent(true);
    }

    private void runTestTwoScopedChildrenWithDependencyOnParent(boolean withDependencyFirst) throws Throwable {
    }

    private KernelDeployment createParentDeployment() throws Throwable {
        return this.createDeployment(PARENT, PARENT_CLASS, null, null, null);
    }

    private KernelDeployment createChildDeployment(String beanName, String dependency, String scope, String alias) {
        return this.createChildDeployment(beanName, beanName, dependency, scope, alias);
    }

    private KernelDeployment createChildDeployment(String deploymentName, String beanName, String dependency, String scope, String alias) {
        return this.createDeployment(deploymentName, beanName, CHILD_CLASS, dependency, scope, alias);
    }

    private KernelDeployment createDeployment(String beanName, String clazz, String dependency, String scope, String alias) {
        return this.createDeployment(beanName, beanName, clazz, dependency, scope, alias);
    }

    private KernelDeployment createDeployment(String deploymentName, String beanName, String clazz, String dependency, String scope, String alias) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)beanName, (String)clazz);
        if (dependency != null) {
            ValueMetaData inject = builder.createInject((Object)dependency);
            builder.addPropertyMetaData("simpleBean", inject);
        }
        if (scope != null) {
            builder.addAnnotation((Annotation)((Object)new ApplicationScopeImpl(scope)));
        }
        if (alias != null) {
            builder.addAnnotation((Annotation)((Object)new AliasesImpl(alias)));
        }
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setName(deploymentName);
        List<BeanMetaData> beans = Collections.singletonList(builder.getBeanMetaData());
        deployment.setBeans(beans);
        return deployment;
    }

    private void assertNoSuchContext(String name) {
        try {
            this.getControllerContext(name);
            ScopingDependencyTestCase.fail((String)(name + " should not be found"));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

