/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins.factory;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.factory.AbstractBeanFactory;
import org.jboss.joinpoint.spi.Joinpoint;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.logging.Logger;

public class GenericBeanFactory
extends AbstractBeanFactory
implements KernelControllerContextAware {
    private static final Logger log = Logger.getLogger(GenericBeanFactory.class);
    protected KernelControllerContext context;

    public GenericBeanFactory(KernelConfigurator configurator) {
        super(configurator);
    }

    public Object createBean() throws Throwable {
        final ClassLoader cl = this.getControllerContextClassLoader();
        AccessControlContext acc = this.getAccessControlContext();
        if (acc == null || System.getSecurityManager() == null) {
            return this.createBean(cl);
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        return GenericBeanFactory.this.createBean(cl);
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        throw new RuntimeException("Error creating bean", t);
                    }
                }
            }, acc);
        }
        catch (PrivilegedActionException e) {
            throw e.getCause();
        }
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }

    private ClassLoader getControllerContextClassLoader() throws Throwable {
        if (this.context != null) {
            if (System.getSecurityManager() == null) {
                try {
                    return this.context.getClassLoader();
                }
                catch (Throwable t) {
                    log.trace((Object)("Unable to retrieve classloader from " + this.context));
                    return null;
                }
            }
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    try {
                        return GenericBeanFactory.this.context.getClassLoader();
                    }
                    catch (Throwable t) {
                        log.trace((Object)("Unable to retrieve classloader from " + GenericBeanFactory.this.context));
                        return null;
                    }
                }
            });
        }
        return null;
    }

    private AccessControlContext getAccessControlContext() throws Throwable {
        if (this.context != null) {
            if (!(this.context instanceof AbstractKernelControllerContext)) {
                return null;
            }
            final AbstractKernelControllerContext akcc = (AbstractKernelControllerContext)this.context;
            if (System.getSecurityManager() == null) {
                return akcc.getAccessControlContext();
            }
            return AccessController.doPrivileged(new PrivilegedAction<AccessControlContext>(){

                @Override
                public AccessControlContext run() {
                    return akcc.getAccessControlContext();
                }
            });
        }
        return null;
    }

    private Object createBean(ClassLoader cl) throws Throwable {
        ClassLoader loader = cl;
        if (loader == null) {
            loader = Configurator.getClassLoader(this.classLoader);
        }
        BeanInfo info = null;
        if (this.bean != null) {
            info = this.configurator.getBeanInfo(this.bean, loader, this.accessMode);
        }
        Joinpoint joinpoint = this.configurator.getConstructorJoinPoint(info, this.constructor, null);
        Object result = joinpoint.dispatch();
        if (info == null && result != null) {
            info = this.configurator.getBeanInfo(result.getClass(), this.accessMode);
        }
        if (this.properties != null && this.properties.size() > 0) {
            for (Map.Entry entry : this.properties.entrySet()) {
                String property = (String)entry.getKey();
                ValueMetaData vmd = (ValueMetaData)entry.getValue();
                PropertyInfo pi = info.getProperty(property);
                pi.set(result, vmd.getValue(pi.getType(), loader));
            }
        }
        this.invokeLifecycle("create", this.create, info, loader, result);
        this.invokeLifecycle("start", this.start, info, loader, result);
        return result;
    }
}

