/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.controller.test;

import java.security.AccessControlException;
import java.util.Collections;
import junit.framework.Test;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.beans.metadata.spi.factory.GenericBeanFactoryMetaData;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.test.kernel.controller.support.PrivilegedBean;
import org.jboss.test.kernel.controller.test.AbstractControllerTest;

public class GenericBeanFactoryAccessControlTestCase
extends AbstractControllerTest {
    public static Test suite() {
        return GenericBeanFactoryAccessControlTestCase.suite(GenericBeanFactoryAccessControlTestCase.class);
    }

    public GenericBeanFactoryAccessControlTestCase(String name) throws Throwable {
        super(name);
    }

    public void testPrivilegedBean() throws Throwable {
        BeanFactory factory = (BeanFactory)this.assertBean("Factory", BeanFactory.class);
        Object object = factory.createBean();
        ClassLoader cl = (ClassLoader)this.assertBean("ClassLoader", ClassLoader.class);
        GenericBeanFactoryAccessControlTestCase.assertEquals((Object)cl, (Object)object.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnPrivilegedBean() throws Throwable {
        GenericBeanFactoryMetaData gbfmd = new GenericBeanFactoryMetaData();
        gbfmd.setName("NonPrivileged");
        gbfmd.setBean(PrivilegedBean.class.getName());
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setName("test");
        deployment.setBeanFactories(Collections.singletonList(gbfmd));
        this.deploy((KernelDeployment)deployment);
        try {
            BeanFactory factory = (BeanFactory)this.assertBean("NonPrivileged", BeanFactory.class);
            try {
                factory.createBean();
                GenericBeanFactoryAccessControlTestCase.fail((String)"Should not be here!");
            }
            catch (Throwable t) {
                GenericBeanFactoryAccessControlTestCase.checkThrowable(AccessControlException.class, (Throwable)t);
            }
        }
        finally {
            this.undeploy((KernelDeployment)deployment);
        }
    }
}

