/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.test;

import java.lang.annotation.Annotation;
import junit.framework.Test;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.metadata.plugins.loader.memory.MemoryMetaDataLoader;
import org.jboss.metadata.spi.MetaData;
import org.jboss.metadata.spi.repository.MutableMetaDataRepository;
import org.jboss.metadata.spi.retrieval.MetaDataRetrieval;
import org.jboss.metadata.spi.scope.CommonLevels;
import org.jboss.metadata.spi.scope.ScopeKey;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.test.kernel.deployment.support.TestAnnotation1;
import org.jboss.test.kernel.deployment.support.TestAnnotation2;
import org.jboss.test.kernel.deployment.support.TestAnnotation3;
import org.jboss.test.kernel.deployment.test.AbstractDeploymentTest;

public class MutableMetaDataTestCase
extends AbstractDeploymentTest {
    public static Test suite() {
        return MutableMetaDataTestCase.suite(MutableMetaDataTestCase.class);
    }

    public MutableMetaDataTestCase(String name) throws Throwable {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMutableMetaData() throws Throwable {
        MutableMetaDataRepository repository = this.getMetaDataRepository().getMetaDataRepository();
        ScopeKey instanceScope = new ScopeKey(CommonLevels.INSTANCE, (Object)"TestBean");
        MemoryMetaDataLoader loader = new MemoryMetaDataLoader(instanceScope);
        TestAnnotation2 annotation = (TestAnnotation2)AnnotationCreator.createAnnotation((String)"@org.jboss.test.kernel.deployment.support.TestAnnotation2", TestAnnotation2.class);
        loader.addAnnotation((Annotation)annotation);
        repository.addMetaDataRetrieval((MetaDataRetrieval)loader);
        ScopeKey setStringScope = new ScopeKey(CommonLevels.JOINPOINT, (Object)"setString");
        MemoryMetaDataLoader stringProperty = new MemoryMetaDataLoader(setStringScope);
        stringProperty.addAnnotation((Annotation)annotation);
        MethodSignature signature = new MethodSignature("setString", new Class[]{String.class});
        loader.addComponentMetaDataRetrieval((Signature)signature, (MetaDataRetrieval)stringProperty);
        KernelDeployment deployment = this.deploy("MutableMetaDataTestCase_NotAutomatic.xml");
        try {
            this.validate();
            KernelControllerContext ctx = this.getControllerContext("TestBean");
            MetaData metaData = ctx.getScopeInfo().getMetaData();
            MutableMetaDataTestCase.assertNotNull((Object)metaData);
            MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation1 from xml", (Object)metaData.getAnnotation(TestAnnotation1.class));
            MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation2 preconfigured", (Object)metaData.getAnnotation(TestAnnotation2.class));
            MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation3 from class", (Object)metaData.getAnnotation(TestAnnotation3.class));
            MetaData setStringMetaData = metaData.getComponentMetaData((Signature)signature);
            MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation1 from xml", (Object)setStringMetaData.getAnnotation(TestAnnotation1.class));
            MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation2 preconfigured", (Object)setStringMetaData.getAnnotation(TestAnnotation2.class));
            MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation3 from class", (Object)setStringMetaData.getAnnotation(TestAnnotation3.class));
        }
        finally {
            this.undeploy(deployment);
        }
        MetaData metaData = repository.getMetaData(instanceScope);
        MutableMetaDataTestCase.assertNotNull((Object)metaData);
        MutableMetaDataTestCase.assertNull((String)"TestAnnotation1 from xml", (Object)metaData.getAnnotation(TestAnnotation1.class));
        MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation2 preconfigured", (Object)metaData.getAnnotation(TestAnnotation2.class));
        MutableMetaDataTestCase.assertNull((String)"TestAnnotation3 from class", (Object)metaData.getAnnotation(TestAnnotation3.class));
        MetaData setStringMetaData = metaData.getComponentMetaData((Signature)signature);
        MutableMetaDataTestCase.assertNull((String)"TestAnnotation1 from xml", (Object)setStringMetaData.getAnnotation(TestAnnotation1.class));
        MutableMetaDataTestCase.assertNotNull((String)"TestAnnotation2 preconfigured", (Object)setStringMetaData.getAnnotation(TestAnnotation2.class));
        MutableMetaDataTestCase.assertNull((String)"TestAnnotation3 from class", (Object)setStringMetaData.getAnnotation(TestAnnotation3.class));
    }
}

