/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.bootstrap.test;

import junit.framework.Test;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap;
import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
import org.jboss.kernel.spi.config.KernelConfig;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.metadata.KernelMetaDataRepository;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.test.AbstractTestCaseWithSetup;
import org.jboss.test.AbstractTestDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootstrapTestCase
extends AbstractTestCaseWithSetup {
    public static Test suite() {
        return BootstrapTestCase.suite(BootstrapTestCase.class);
    }

    public static AbstractTestDelegate getDelegate(Class<?> clazz) throws Exception {
        AbstractTestDelegate delegate = new AbstractTestDelegate(clazz);
        delegate.enableSecurity = true;
        return delegate;
    }

    public BootstrapTestCase(String name) {
        super(name);
    }

    public void testBasicBootstrap() throws Exception {
        BasicBootstrap bootstrap = new BasicBootstrap();
        bootstrap.run();
        Kernel kernel = bootstrap.getKernel();
        this.getLog().debug((Object)("Got kernel: " + kernel));
        BootstrapTestCase.assertNotNull((Object)kernel);
        KernelRegistry registry = kernel.getRegistry();
        BootstrapTestCase.assertNotNull((Object)registry);
        this.check("Kernel", registry, kernel, "jboss.kernel:service=Kernel", Kernel.class.getName());
        this.check("KernelRegistry", registry, registry, "jboss.kernel:service=KernelRegistry", "org.jboss.kernel.plugins.registry.basic.BasicKernelRegistry");
        KernelBus bus = kernel.getBus();
        this.check("KernelBus", registry, bus, "jboss.kernel:service=KernelBus", "org.jboss.kernel.plugins.registry.basic.LifecycleAwareKernelBus");
        KernelConfig config = kernel.getConfig();
        this.check("KernelConfig", registry, config, "jboss.kernel:service=KernelConfig", PropertyKernelConfig.class.getName());
        KernelConfigurator configurator = kernel.getConfigurator();
        this.check("KernelConfigurator", registry, configurator, "jboss.kernel:service=KernelConfigurator", "org.jboss.kernel.plugins.config.AbstractKernelConfigurator");
        KernelController controller = kernel.getController();
        this.check("KernelController", registry, controller, "jboss.kernel:service=KernelController", "org.jboss.kernel.plugins.dependency.AbstractKernelController");
        KernelEventManager eventManager = kernel.getEventManager();
        this.check("KernelEventManager", registry, eventManager, "jboss.kernel:service=KernelEventManager", "org.jboss.kernel.plugins.event.AbstractEventManager");
        KernelMetaDataRepository metaDataRepository = kernel.getMetaDataRepository();
        this.check("KernelMetaDataRepository", registry, metaDataRepository, "jboss.kernel:service=MetaDataRepository", "org.jboss.kernel.plugins.metadata.basic.BasicKernelMetaDataRepository");
    }

    protected void check(String context, KernelRegistry registry, Object object, Object name, String className) throws Exception {
        this.getLog().debug((Object)("Checking " + context + ": " + object));
        BootstrapTestCase.assertNotNull((Object)object);
        BootstrapTestCase.assertEquals((String)object.getClass().getName(), (String)className);
        KernelRegistryEntry entry = registry.getEntry(name);
        Object registered = entry.getTarget();
        BootstrapTestCase.assertEquals((Object)object, (Object)registered);
    }

    protected void configureLogging() {
    }
}

