/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractSupplyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBean;
import org.jboss.test.kernel.dependency.support.SimpleBeanImpl;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class DemandDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return DemandDependencyTestCase.suite(DemandDependencyTestCase.class);
    }

    public DemandDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public DemandDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testDemandDependencyCorrectOrder() throws Throwable {
        this.demandDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean1);
        DemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBean bean2 = (SimpleBean)context2.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean2);
        DemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
    }

    public void demandDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testDemandDependencyWrongOrder() throws Throwable {
        this.demandDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", this.getWhenRequiredState());
        ControllerContext context1 = this.assertInstall(0, "Name1");
        DemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean1);
        DemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBean bean2 = (SimpleBean)context2.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean2);
        DemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
    }

    public void demandDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testDemandDependencyReinstall() throws Throwable {
        this.demandDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBean bean1 = (SimpleBean)context1.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean1);
        DemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        SimpleBean bean2 = (SimpleBean)context2.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean2);
        DemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        this.assertUninstall("Name1");
        DemandDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context1.getState());
        DemandDependencyTestCase.assertEquals((Object)this.getWhenRequiredState(), (Object)context2.getState());
        this.assertNotInstalled("Name2");
        this.assertContext("Name2", this.getWhenRequiredState());
        context1 = this.assertInstall(0, "Name1");
        DemandDependencyTestCase.assertNotNull((Object)context1);
        DemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        bean1 = (SimpleBean)context1.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean1);
        DemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimpleBean)context2.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean2);
        DemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
        this.assertUninstall("Name2");
        DemandDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context1.getState());
        DemandDependencyTestCase.assertEquals((Object)ControllerState.ERROR, (Object)context2.getState());
        bean1 = (SimpleBean)context1.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean1);
        DemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        context2 = this.assertInstall(1, "Name2");
        bean1 = (SimpleBean)context1.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean1);
        DemandDependencyTestCase.assertEquals((String)"String1", (String)bean1.getString());
        bean2 = (SimpleBean)context2.getTarget();
        DemandDependencyTestCase.assertNotNull((Object)bean2);
        DemandDependencyTestCase.assertEquals((String)"String2", (String)bean2.getString());
    }

    public void demandDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected ControllerState getWhenRequiredState() {
        return ControllerState.PRE_INSTALL;
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes1 = new HashSet<AbstractPropertyMetaData>();
        attributes1.add(new AbstractPropertyMetaData("string", "String1"));
        metaData1.setProperties(attributes1);
        HashSet<AbstractSupplyMetaData> supplies = new HashSet<AbstractSupplyMetaData>();
        supplies.add(new AbstractSupplyMetaData((Object)"WhatIWant"));
        metaData1.setSupplies(supplies);
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("Name2", SimpleBeanImpl.class.getName());
        HashSet<AbstractPropertyMetaData> attributes2 = new HashSet<AbstractPropertyMetaData>();
        attributes2.add(new AbstractPropertyMetaData("string", "String2"));
        metaData2.setProperties(attributes2);
        HashSet<AbstractDemandMetaData> demands = new HashSet<AbstractDemandMetaData>();
        demands.add(new AbstractDemandMetaData((Object)"WhatIWant"));
        metaData2.setDemands(demands);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }
}

