/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.support;

import java.lang.reflect.Method;
import org.jboss.beans.metadata.api.annotations.Constructor;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.joinpoint.plugins.Config;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.reflect.plugins.introspection.ReflectMethodInfoImpl;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.FieldInfo;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticInjector {
    private KernelConfigurator configurator;

    @Constructor
    public StaticInjector(@Inject(bean="jboss.kernel:service=KernelConfigurator") KernelConfigurator configurator) {
        if (configurator == null) {
            throw new IllegalArgumentException("Null configurator");
        }
        this.configurator = configurator;
    }

    public void injectToMethod(Class<?> clazz, String method, Object value, Class<?> signature) throws Throwable {
        this.injectToMethod(clazz, method, value, signature, true);
    }

    public void injectToNonPublicMethod(Class<?> clazz, String method, Object value, Class<?> signature) throws Throwable {
        this.injectToMethod(clazz, method, value, signature, false);
    }

    private void injectToMethod(Class<?> clazz, String method, Object value, Class<?> signature, boolean isPublic) throws Throwable {
        ClassInfo classInfo = this.configurator.getClassInfo(clazz);
        MethodInfo mi = Config.findMethodInfo((ClassInfo)classInfo, (String)method, (String[])new String[]{signature.getName()}, (boolean)true, (boolean)isPublic);
        if (!isPublic) {
            if (mi instanceof ReflectMethodInfoImpl) {
                ReflectMethodInfoImpl rmi = (ReflectMethodInfoImpl)mi;
                Method m = rmi.getMethod();
                m.setAccessible(true);
            } else {
                throw new IllegalArgumentException("Cannot set accessible on method info: " + mi);
            }
        }
        mi.invoke(null, new Object[]{value});
    }

    public void injectToField(Class<?> clazz, String name, Object value) throws Throwable {
        ClassInfo classInfo = this.configurator.getClassInfo(clazz);
        FieldInfo fi = Config.findFieldInfo((ClassInfo)classInfo, (String)name);
        fi.set(null, value);
    }
}

