/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.registry.test;

import java.util.Date;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.registry.basic.LifecycleAwareKernelBus;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.test.kernel.AbstractKernelTest;
import org.jboss.test.kernel.registry.support.BusBean;

public class BusTestCase
extends AbstractKernelTest {
    public static Test suite() {
        return BusTestCase.suite(BusTestCase.class);
    }

    public BusTestCase(String name) {
        super(name);
    }

    public void testSetAndGet() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelConfigurator configurator = kernel.getConfigurator();
        registry.registerEntry((Object)"Bus", BusTestCase.makeContext(configurator, "Name1", new BusBean()));
        KernelBus bus = kernel.getBus();
        Object result1 = bus.get((Object)"Bus", "value");
        BusTestCase.assertNull((String)"Result 1", (Object)result1);
        bus.set((Object)"Bus", "value", (Object)"BusBus");
        Object result2 = bus.get((Object)"Bus", "value");
        BusTestCase.assertEquals((Object)"BusBus", (Object)result2);
    }

    public void testInvoke() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelRegistry registry = kernel.getRegistry();
        KernelConfigurator configurator = kernel.getConfigurator();
        KernelRegistryEntry entry1 = BusTestCase.makeContext(configurator, "Name1", "A string");
        entry1.setState(ControllerState.INSTALLED);
        registry.registerEntry((Object)"Name1", entry1);
        KernelRegistryEntry entry2 = BusTestCase.makeContext(configurator, "Name2", "B string");
        entry2.setState(ControllerState.INSTALLED);
        registry.registerEntry((Object)"Name2", entry2);
        KernelBus bus = kernel.getBus();
        Object result1 = bus.invoke((Object)"Name1", "toString", new Object[0], new String[0]);
        Object result2 = bus.invoke((Object)"Name2", "toString", new Object[0], new String[0]);
        BusTestCase.assertEquals((Object)"A string", (Object)result1);
        BusTestCase.assertEquals((Object)"B string", (Object)result2);
    }

    public void testLifecycle() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"Name1", (String)BusBean.class.getName());
        builder.addStartParameter(String.class.getName(), "123-Start");
        builder.setStop("doStop");
        builder.setDestroy("executeDestroy");
        builder.addDestroyParameter("int", (Object)123);
        builder.addDestroyParameter(Date.class.getName(), (Object)new Date());
        KernelControllerContext context = controller.install(builder.getBeanMetaData());
        BusTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context.getState());
        KernelBus bus = kernel.getBus();
        this.assertInstanceOf(bus, LifecycleAwareKernelBus.class);
        bus.invoke((Object)"Name1", "executeDestroy", new Object[]{-1, new Date()}, new String[]{Integer.TYPE.getName(), Date.class.getName()});
        BusTestCase.assertEquals((Object)ControllerState.CONFIGURED, (Object)context.getState());
        bus.invoke((Object)"Name1", "create", null, null);
        BusTestCase.assertEquals((Object)ControllerState.CREATE, (Object)context.getState());
        bus.invoke((Object)"Name1", "start", new Object[]{"foobar"}, new String[]{String.class.getName()});
        BusTestCase.assertEquals((Object)ControllerState.START, (Object)context.getState());
        bus.invoke((Object)"Name1", "doStop", null, null);
        BusTestCase.assertEquals((Object)ControllerState.CREATE, (Object)context.getState());
    }

    protected static KernelRegistryEntry makeContext(KernelConfigurator configurator, String name, Object target) throws Throwable {
        return new AbstractKernelControllerContext(configurator.getBeanInfo(target.getClass()), (BeanMetaData)new AbstractBeanMetaData(name, target.getClass().getName()), target);
    }
}

