/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.api.model.AutowireType;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractRelatedClassMetaData;
import org.jboss.beans.metadata.plugins.InstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.UninstallCallbackMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaDataFactory;
import org.jboss.beans.metadata.spi.CallbackMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.dependency.spi.Cardinality;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ErrorHandlingMode;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployer;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.metadata.spi.MetaData;
import org.jboss.test.kernel.config.support.SimpleAnnotation;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.SimpleCallbackBean;
import org.jboss.test.kernel.config.support.SimpleLifecycleBean;
import org.jboss.test.kernel.config.support.Transformer;
import org.jboss.test.kernel.config.support.TrimTransformer;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class BeanMetaDataBuilderTestCase
extends AbstractKernelConfigTest {
    public static Test suite() {
        return BeanMetaDataBuilderTestCase.suite(BeanMetaDataBuilderTestCase.class);
    }

    public BeanMetaDataBuilderTestCase(String name) throws Throwable {
        super(name);
    }

    public void testConstructor() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"FromBMD", (String)SimpleBean.class.getName());
        builder.addConstructorParameter(String.class.getName(), "TestConstructor");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        SimpleBean fbmd = (SimpleBean)this.instantiateAndConfigure(beanMetaData);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)fbmd);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)fbmd.getConstructorUsed());
        BeanMetaDataBuilderTestCase.assertEquals((String)"TestConstructor", (String)fbmd.getConstructorUsed());
    }

    public void testProperty() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"PropBMD", (String)SimpleBean.class.getName()).addPropertyMetaData("adouble", (Object)3.1459).addPropertyMetaData("anint", "123").addPropertyMetaData("collection", new ArrayList());
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        SimpleBean pbmd = (SimpleBean)this.instantiateAndConfigure(beanMetaData);
        BeanMetaDataBuilderTestCase.assertNotNull((Object)pbmd);
        this.assertEquals(3.1459, pbmd.getAdouble());
        BeanMetaDataBuilderTestCase.assertEquals((int)123, (int)pbmd.getAnint());
        BeanMetaDataBuilderTestCase.assertNotNull(pbmd.getCollection());
        BeanMetaDataBuilderTestCase.assertTrue((boolean)pbmd.getCollection().isEmpty());
    }

    public void testLifecycle() throws Throwable {
        Kernel kernel = this.bootstrap();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"SLB", (String)SimpleLifecycleBean.class.getName()).addCreateParameter(String.class.getName(), "ParamCreate").setStart("doStart").addStartParameter(String.class.getName(), "ParamStart").setStop("doStop").addStopParameter(String.class.getName(), "ParamStop").addDestroyParameter(String.class.getName(), "ParamDestroy");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        KernelController controller = kernel.getController();
        KernelControllerContext context = controller.install(beanMetaData);
        SimpleLifecycleBean slb = (SimpleLifecycleBean)context.getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)slb);
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamCreate", (String)slb.getCreate());
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamStart", (String)slb.getStart());
        controller.uninstall((Object)"SLB");
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamStop", (String)slb.getStop());
        BeanMetaDataBuilderTestCase.assertEquals((String)"ParamDestroy", (String)slb.getDestroy());
    }

    public void testInstall() throws Throwable {
        Kernel kernel = this.bootstrap();
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"SLB", (String)SimpleLifecycleBean.class.getName()).addInstall("installParam", String.class.getName(), "Install").addUninstall("uninstallParam", String.class.getName(), "Uninstall");
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        KernelController controller = kernel.getController();
        KernelControllerContext context = controller.install(beanMetaData);
        SimpleLifecycleBean slb = (SimpleLifecycleBean)context.getTarget();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)slb);
        BeanMetaDataBuilderTestCase.assertEquals((String)"Install", (String)slb.getInstall());
        controller.uninstall((Object)"SLB");
        BeanMetaDataBuilderTestCase.assertEquals((String)"Uninstall", (String)slb.getInstall());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDemandSupply() throws Throwable {
        BeanMetaDataBuilder demand = BeanMetaDataBuilderFactory.createBuilder((String)"DemandBean", (String)SimpleBean.class.getName());
        demand.addDemand((Object)"Barrier");
        BeanMetaDataFactory demandBean = demand.getBeanMetaDataFactory();
        BeanMetaDataBuilder supply = BeanMetaDataBuilderFactory.createBuilder((String)"SupplyBean", (String)SimpleLifecycleBean.class.getName());
        supply.addSupply((Object)"Barrier");
        BeanMetaDataFactory supplyBean = supply.getBeanMetaDataFactory();
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeanFactories(Arrays.asList(demandBean, supplyBean));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        try {
            Object db = controller.getInstalledContext((Object)"DemandBean").getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)db);
            Object sb = controller.getInstalledContext((Object)"SupplyBean").getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)sb);
        }
        finally {
            deployer.undeploy((KernelDeployment)deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDependency() throws Throwable {
        BeanMetaDataBuilder dependOn = BeanMetaDataBuilderFactory.createBuilder((String)"DependOnBean", (String)SimpleBean.class.getName());
        dependOn.addDependency((Object)"DependencyResolver");
        BeanMetaDataFactory dependOnBean = dependOn.getBeanMetaDataFactory();
        BeanMetaDataBuilder resolver = BeanMetaDataBuilderFactory.createBuilder((String)"DependencyResolver", (String)SimpleLifecycleBean.class.getName());
        BeanMetaDataFactory resolverBean = resolver.getBeanMetaDataFactory();
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeanFactories(Arrays.asList(dependOnBean, resolverBean));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        try {
            Object db = controller.getInstalledContext((Object)"DependOnBean").getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)db);
            Object rb = controller.getInstalledContext((Object)"DependencyResolver").getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)rb);
        }
        finally {
            deployer.undeploy((KernelDeployment)deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCollectionProperties() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"CollectionBean", (String)SimpleBean.class.getName());
        List array = builder.createArray();
        array.add(builder.createValue((Object)new Integer(5)));
        array.add(builder.createValue((Object)new Integer(10)));
        builder.addPropertyMetaData("array", (Collection)array);
        List list = builder.createList();
        list.add(builder.createValue((Object)"One"));
        list.add(builder.createValue((Object)"Two"));
        builder.addPropertyMetaData("list", (Collection)list);
        Set set = builder.createSet();
        set.add(builder.createValue((Object)"En"));
        set.add(builder.createValue((Object)"To"));
        builder.addPropertyMetaData("set", (Collection)set);
        Collection collection = builder.createCollection();
        collection.add(builder.createValue((Object)"Eins"));
        collection.add(builder.createValue((Object)"Zwei"));
        builder.addPropertyMetaData("collection", collection);
        Map map = builder.createMap();
        map.put(builder.createValue((Object)"One"), builder.createValue((Object)"Uno"));
        map.put(builder.createValue((Object)"Two"), builder.createValue((Object)"Dos"));
        builder.addPropertyMetaData("map", map);
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeanFactories(Arrays.asList(builder.getBeanMetaDataFactory()));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        try {
            Object o = controller.getInstalledContext((Object)"CollectionBean").getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)o);
            this.assertInstanceOf(o, SimpleBean.class);
            SimpleBean bean = (SimpleBean)o;
            Object[] arr = bean.getArray();
            BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)arr.length);
            BeanMetaDataBuilderTestCase.assertEquals((Object)5, (Object)arr[0]);
            BeanMetaDataBuilderTestCase.assertEquals((Object)10, (Object)arr[1]);
            List<?> lst = bean.getList();
            BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)lst.size());
            BeanMetaDataBuilderTestCase.assertEquals((Object)"One", lst.get(0));
            BeanMetaDataBuilderTestCase.assertEquals((Object)"Two", lst.get(1));
            Set<?> st = bean.getSet();
            BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)lst.size());
            BeanMetaDataBuilderTestCase.assertTrue((boolean)st.contains("En"));
            BeanMetaDataBuilderTestCase.assertTrue((boolean)st.contains("To"));
            Collection<?> coll = bean.getCollection();
            BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)lst.size());
            BeanMetaDataBuilderTestCase.assertTrue((boolean)coll.contains("Eins"));
            BeanMetaDataBuilderTestCase.assertTrue((boolean)coll.contains("Zwei"));
            Map<?, ?> mp = bean.getMap();
            BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)mp.size());
            BeanMetaDataBuilderTestCase.assertEquals((Object)"Uno", mp.get("One"));
            BeanMetaDataBuilderTestCase.assertEquals((Object)"Dos", mp.get("Two"));
        }
        finally {
            deployer.undeploy((KernelDeployment)deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReplacePropertyMetaData() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"ReplaceBean", (String)SimpleBean.class.getName());
        builder.addPropertyMetaData("anInt", (Object)new Integer(1));
        builder.addPropertyMetaData("anInt", (Object)new Integer(5));
        builder.addPropertyMetaData("AString", "One");
        builder.addPropertyMetaData("AString", "Two");
        ValueMetaData value = builder.createValue((Object)"Three");
        builder.addPropertyMetaData("anObject", value);
        value = builder.createValue((Object)"Four");
        builder.addPropertyMetaData("anObject", value);
        List array = builder.createArray();
        builder.addPropertyMetaData("array", (Collection)array);
        array = builder.createArray();
        array.add(builder.createValue((Object)new Integer(5)));
        array.add(builder.createValue((Object)new Integer(10)));
        builder.addPropertyMetaData("array", (Collection)array);
        Map map = builder.createMap();
        builder.addPropertyMetaData("map", map);
        map = builder.createMap();
        map.put(builder.createValue((Object)"One"), builder.createValue((Object)"Uno"));
        map.put(builder.createValue((Object)"Two"), builder.createValue((Object)"Dos"));
        builder.addPropertyMetaData("map", map);
        AbstractKernelDeployment deployment = new AbstractKernelDeployment();
        deployment.setBeanFactories(Arrays.asList(builder.getBeanMetaDataFactory()));
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractKernelDeployer deployer = new AbstractKernelDeployer(kernel);
        deployer.deploy((KernelDeployment)deployment);
        try {
            Object o = controller.getInstalledContext((Object)"ReplaceBean").getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)o);
            this.assertInstanceOf(o, SimpleBean.class);
            SimpleBean bean = (SimpleBean)o;
            Integer integer = bean.getAnInt();
            BeanMetaDataBuilderTestCase.assertEquals((Object)new Integer(5), (Object)integer);
            String string = bean.getAString();
            BeanMetaDataBuilderTestCase.assertEquals((String)"Two", (String)string);
            Object obj = bean.getAnObject();
            BeanMetaDataBuilderTestCase.assertEquals((Object)"Four", (Object)obj);
            Object[] arr = bean.getArray();
            BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)arr.length);
            BeanMetaDataBuilderTestCase.assertEquals((Object)5, (Object)arr[0]);
            BeanMetaDataBuilderTestCase.assertEquals((Object)10, (Object)arr[1]);
            Map<?, ?> mp = bean.getMap();
            BeanMetaDataBuilderTestCase.assertEquals((int)2, (int)mp.size());
            BeanMetaDataBuilderTestCase.assertEquals((Object)"Uno", mp.get("One"));
            BeanMetaDataBuilderTestCase.assertEquals((Object)"Dos", mp.get("Two"));
        }
        finally {
            deployer.undeploy((KernelDeployment)deployment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCallbacks() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        try {
            BeanMetaData beanMetaData = BeanMetaDataBuilder.createBuilder((String)"t", (String)TrimTransformer.class.getName()).getBeanMetaData();
            KernelControllerContext cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            Object target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            Transformer transformer = (Transformer)this.assertInstanceOf(target, Transformer.class);
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"ct1", (String)SimpleCallbackBean.class.getName());
            builder.addPropertyInstallCallback("transformers");
            builder.addPropertyUninstallCallback("transformers");
            beanMetaData = builder.getBeanMetaData();
            List callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            CallbackMetaData callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            SimpleCallbackBean bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
            builder = BeanMetaDataBuilder.createBuilder((String)"ct2", (String)SimpleCallbackBean.class.getName());
            builder.addPropertyInstallCallback("transformers", Cardinality.ONE_TO_MANY);
            builder.addPropertyUninstallCallback("transformers", Cardinality.ONE_TO_MANY);
            beanMetaData = builder.getBeanMetaData();
            callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ONE_TO_MANY, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ONE_TO_MANY, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
            builder = BeanMetaDataBuilder.createBuilder((String)"ct3", (String)SimpleCallbackBean.class.getName());
            builder.addPropertyInstallCallback("transformers", ControllerState.CREATE);
            builder.addPropertyUninstallCallback("transformers", ControllerState.CREATE);
            beanMetaData = builder.getBeanMetaData();
            callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
            builder = BeanMetaDataBuilder.createBuilder((String)"ct4", (String)SimpleCallbackBean.class.getName());
            builder.addPropertyInstallCallback("transformers", Set.class.getName(), ControllerState.CREATE, ControllerState.START, Cardinality.ZERO_TO_ONE);
            builder.addPropertyUninstallCallback("transformers", Set.class.getName(), ControllerState.CREATE, ControllerState.START, Cardinality.ZERO_TO_ONE);
            beanMetaData = builder.getBeanMetaData();
            callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.START, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertEquals((String)Set.class.getName(), (String)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ZERO_TO_ONE, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"transformers", (String)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.START, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertEquals((String)Set.class.getName(), (String)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ZERO_TO_ONE, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
            builder = BeanMetaDataBuilder.createBuilder((String)"mct1", (String)SimpleCallbackBean.class.getName());
            builder.addMethodInstallCallback("addTransformer");
            builder.addMethodUninstallCallback("removeTransformer");
            beanMetaData = builder.getBeanMetaData();
            callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"addTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"removeTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
            builder = BeanMetaDataBuilder.createBuilder((String)"mct2", (String)SimpleCallbackBean.class.getName());
            builder.addMethodInstallCallback("addTransformer", Cardinality.ONE_TO_MANY);
            builder.addMethodUninstallCallback("removeTransformer", Cardinality.ONE_TO_MANY);
            beanMetaData = builder.getBeanMetaData();
            callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"addTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ONE_TO_MANY, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"removeTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ONE_TO_MANY, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
            builder = BeanMetaDataBuilder.createBuilder((String)"mct3", (String)SimpleCallbackBean.class.getName());
            builder.addMethodInstallCallback("addTransformer", ControllerState.CREATE);
            builder.addMethodUninstallCallback("removeTransformer", ControllerState.CREATE);
            beanMetaData = builder.getBeanMetaData();
            callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"addTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"removeTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
            builder = BeanMetaDataBuilder.createBuilder((String)"mct4", (String)SimpleCallbackBean.class.getName());
            builder.addMethodInstallCallback("addTransformer", Transformer.class.getName(), ControllerState.CREATE, ControllerState.START, Cardinality.ZERO_TO_ONE);
            builder.addMethodUninstallCallback("removeTransformer", Transformer.class.getName(), ControllerState.CREATE, ControllerState.START, Cardinality.ZERO_TO_ONE);
            beanMetaData = builder.getBeanMetaData();
            callbacks = beanMetaData.getInstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, InstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"addTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.START, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertEquals((String)Transformer.class.getName(), (String)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ZERO_TO_ONE, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            callbacks = beanMetaData.getUninstallCallbacks();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callbacks);
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)callbacks.size());
            callback = (CallbackMetaData)callbacks.get(0);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)callback);
            this.assertInstanceOf(callback, UninstallCallbackMetaData.class, false);
            BeanMetaDataBuilderTestCase.assertEquals((String)"removeTransformer", (String)callback.getMethodName());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.START, (Object)callback.getDependentState());
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.CREATE, (Object)callback.getState());
            BeanMetaDataBuilderTestCase.assertEquals((String)Transformer.class.getName(), (String)callback.getSignature());
            BeanMetaDataBuilderTestCase.assertEquals((Object)Cardinality.ZERO_TO_ONE, (Object)callback.getCardinality());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getProperty());
            BeanMetaDataBuilderTestCase.assertNull((Object)callback.getParameters());
            cc = controller.install(beanMetaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            BeanMetaDataBuilderTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)cc.getState());
            target = cc.getTarget();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)target);
            bean = (SimpleCallbackBean)this.assertInstanceOf(target, SimpleCallbackBean.class);
            BeanMetaDataBuilderTestCase.assertNotNull(bean.getTransformers());
            BeanMetaDataBuilderTestCase.assertEquals((int)1, (int)bean.getTransformers().size());
            BeanMetaDataBuilderTestCase.assertSame((Object)transformer, bean.getTransformers().iterator().next());
        }
        finally {
            controller.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAliases() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        try {
            BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"bean", (String)SimpleBean.class.getName());
            builder.addAlias((Object)"alias");
            controller.install(builder.getBeanMetaData());
            BeanMetaDataBuilderTestCase.assertNotNull((Object)controller.getInstalledContext((Object)"alias"));
            builder = BeanMetaDataBuilderFactory.createBuilder((String)"other", (String)SimpleBean.class.getName());
            String foobar = "foobar";
            builder.setAliases(Collections.singleton(foobar));
            controller.install(builder.getBeanMetaData());
            BeanMetaDataBuilderTestCase.assertNotNull((Object)controller.getInstalledContext((Object)"foobar"));
        }
        finally {
            controller.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAnnotations() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        try {
            BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)"bean", (String)SimpleBean.class.getName());
            builder.addAnnotation("@" + SimpleAnnotation.class.getName() + "(name=\"foobar\")");
            controller.install(builder.getBeanMetaData());
            ControllerContext cc = controller.getInstalledContext((Object)"bean");
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            MetaData metaData = cc.getScopeInfo().getMetaData();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)metaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)metaData.getAnnotation(SimpleAnnotation.class));
            builder = BeanMetaDataBuilderFactory.createBuilder((String)"other", (String)SimpleBean.class.getName());
            builder.setAnnotations(Collections.singleton("@" + SimpleAnnotation.class.getName() + "(name=\"foobar\")"));
            controller.install(builder.getBeanMetaData());
            cc = controller.getInstalledContext((Object)"other");
            BeanMetaDataBuilderTestCase.assertNotNull((Object)cc);
            metaData = cc.getScopeInfo().getMetaData();
            BeanMetaDataBuilderTestCase.assertNotNull((Object)metaData);
            BeanMetaDataBuilderTestCase.assertNotNull((Object)metaData.getAnnotation(SimpleAnnotation.class));
        }
        finally {
            controller.shutdown();
        }
    }

    public void testNewEnums() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)Object.class.getName());
        builder.setErrorHandlingMode(ErrorHandlingMode.MANUAL);
        builder.setAutowireType(AutowireType.CONSTRUCTOR);
        builder.setAutowireCandidate(false);
        BeanMetaData bmd = builder.getBeanMetaData();
        BeanMetaDataBuilderTestCase.assertEquals((Object)ErrorHandlingMode.MANUAL, (Object)bmd.getErrorHandlingMode());
        BeanMetaDataBuilderTestCase.assertEquals((Object)AutowireType.CONSTRUCTOR, (Object)bmd.getAutowireType());
        BeanMetaDataBuilderTestCase.assertFalse((boolean)bmd.isAutowireCandidate());
    }

    public void testBeanMetaDataFactory() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"bean", (String)Object.class.getName());
        BeanMetaDataFactory f1 = builder.getBeanMetaDataFactory();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)f1);
        BeanMetaDataFactory f2 = builder.asBeanMetaDataFactory();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)f2);
        List b1 = f1.getBeans();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)b1);
        List b2 = f1.getBeans();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)b2);
        BeanMetaDataBuilderTestCase.assertEquals((Object)b1, (Object)b2);
        AbstractBeanMetaData abmd = new AbstractBeanMetaData("bean", Object.class.getName());
        builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)abmd);
        BeanMetaDataBuilderTestCase.assertSame((Object)abmd, (Object)builder.getBeanMetaDataFactory());
        BeanMetaDataFactory bmdf = builder.asBeanMetaDataFactory();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)bmdf);
        List beans = bmdf.getBeans();
        BeanMetaDataBuilderTestCase.assertNotNull((Object)beans);
        BeanMetaDataBuilderTestCase.assertFalse((boolean)beans.isEmpty());
        BeanMetaDataBuilderTestCase.assertSame((Object)abmd, beans.get(0));
    }

    public void testRelatedClassName() throws Throwable {
        AbstractRelatedClassMetaData rcmd = new AbstractRelatedClassMetaData(Object.class.getName());
        HashSet<AbstractRelatedClassMetaData> related = new HashSet<AbstractRelatedClassMetaData>();
        related.add(rcmd);
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"Bean");
        builder.addRelatedClass(Object.class.getName(), new Object[0]);
        BeanMetaData bmd = builder.getBeanMetaData();
        BeanMetaDataBuilderTestCase.assertEquals(related, (Object)bmd.getRelated());
    }

    public void testRelatedClassNameWithEnabled() throws Throwable {
        AbstractRelatedClassMetaData rcmd = new AbstractRelatedClassMetaData(Object.class.getName());
        rcmd.setEnabledValue((Object)"aop");
        HashSet<AbstractRelatedClassMetaData> related = new HashSet<AbstractRelatedClassMetaData>();
        related.add(rcmd);
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"Bean");
        builder.addRelatedClass(Object.class.getName(), new Object[]{"aop"});
        BeanMetaData bmd = builder.getBeanMetaData();
        BeanMetaDataBuilderTestCase.assertEquals(related, (Object)bmd.getRelated());
    }

    public void testMultipleRelatedClassNameWithMultipleEnabled() throws Throwable {
        AbstractRelatedClassMetaData rcmd1 = new AbstractRelatedClassMetaData(Object.class.getName());
        rcmd1.setEnabled(new HashSet<String>(Arrays.asList("aop", "md")));
        AbstractRelatedClassMetaData rcmd2 = new AbstractRelatedClassMetaData(String.class.getName());
        rcmd2.setEnabled(new HashSet<String>(Arrays.asList("qwert", "foobar")));
        HashSet<AbstractRelatedClassMetaData> related = new HashSet<AbstractRelatedClassMetaData>();
        related.add(rcmd1);
        related.add(rcmd2);
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"Bean");
        builder.addRelatedClass(Object.class.getName(), new Object[]{"aop", "md"});
        builder.addRelatedClass(String.class.getName(), new Object[]{"qwert", "foobar"});
        BeanMetaData bmd = builder.getBeanMetaData();
        BeanMetaDataBuilderTestCase.assertEquals(related, (Object)bmd.getRelated());
    }

    public void testIgnoredLifecycle() throws Throwable {
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)"test");
        builder.ignoreCreate();
        builder.ignoreStart();
        builder.ignoreStop();
        builder.ignoreDestroy();
        BeanMetaData bmd = builder.getBeanMetaData();
        this.assertIgnoredLifecycle(bmd.getCreate());
        this.assertIgnoredLifecycle(bmd.getStart());
        this.assertIgnoredLifecycle(bmd.getStop());
        this.assertIgnoredLifecycle(bmd.getDestroy());
    }

    protected void assertIgnoredLifecycle(LifecycleMetaData lmd) {
        BeanMetaDataBuilderTestCase.assertNotNull((Object)lmd);
        BeanMetaDataBuilderTestCase.assertTrue((boolean)lmd.isIgnored());
    }
}

