/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.dependency.test;

import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.test.kernel.dependency.support.SimpleBeanWithLifecycle;
import org.jboss.test.kernel.dependency.test.OldAbstractKernelDependencyTest;

public class PlainLifecycleDependencyTestCase
extends OldAbstractKernelDependencyTest {
    public static Test suite() {
        return PlainLifecycleDependencyTestCase.suite(PlainLifecycleDependencyTestCase.class);
    }

    public PlainLifecycleDependencyTestCase(String name) throws Throwable {
        super(name);
    }

    public PlainLifecycleDependencyTestCase(String name, boolean xmltest) throws Throwable {
        super(name, xmltest);
    }

    public void testPlainLifecycleDependencyCorrectOrder() throws Throwable {
        this.plainLifecycleDependencyCorrectOrder();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBeanWithLifecycle bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        SimpleBeanWithLifecycle bean2 = (SimpleBeanWithLifecycle)context2.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        PlainLifecycleDependencyTestCase.assertEquals((int)1, (int)bean1.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)3, (int)bean2.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)2, (int)bean1.startOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)4, (int)bean2.startOrder);
    }

    public void plainLifecycleDependencyCorrectOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testPlainLifecycleDependencyWrongOrder() throws Throwable {
        this.plainLifecycleDependencyWrongOrder();
        ControllerContext context2 = this.assertInstall(1, "Name2", ControllerState.CONFIGURED);
        ControllerContext context1 = this.assertInstall(0, "Name1");
        PlainLifecycleDependencyTestCase.assertEquals((Object)ControllerState.INSTALLED, (Object)context2.getState());
        SimpleBeanWithLifecycle bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        SimpleBeanWithLifecycle bean2 = (SimpleBeanWithLifecycle)context2.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        PlainLifecycleDependencyTestCase.assertEquals((int)1, (int)bean1.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)2, (int)bean2.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)3, (int)bean1.startOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)4, (int)bean2.startOrder);
    }

    public void plainLifecycleDependencyWrongOrder() throws Throwable {
        this.buildMetaData();
    }

    public void testPlainLifecycleDependencyReinstall() throws Throwable {
        this.plainLifecycleDependencyReinstall();
        ControllerContext context1 = this.assertInstall(0, "Name1");
        ControllerContext context2 = this.assertInstall(1, "Name2");
        SimpleBeanWithLifecycle bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        SimpleBeanWithLifecycle bean2 = (SimpleBeanWithLifecycle)context2.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        PlainLifecycleDependencyTestCase.assertEquals((int)1, (int)bean1.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)2, (int)bean1.startOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)3, (int)bean2.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)4, (int)bean2.startOrder);
        this.uninstall("Name1");
        this.assertContext("Name2", ControllerState.CONFIGURED);
        PlainLifecycleDependencyTestCase.assertEquals((int)5, (int)bean2.stopOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)6, (int)bean1.stopOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)7, (int)bean2.destroyOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)8, (int)bean1.destroyOrder);
        context1 = this.assertInstall(0, "Name1");
        bean1 = (SimpleBeanWithLifecycle)context1.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean1);
        this.assertContext("Name2", ControllerState.INSTALLED);
        PlainLifecycleDependencyTestCase.assertEquals((int)9, (int)bean1.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)10, (int)bean2.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)11, (int)bean1.startOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)12, (int)bean2.startOrder);
        this.uninstall("Name2");
        this.assertContext("Name1", ControllerState.INSTALLED);
        PlainLifecycleDependencyTestCase.assertEquals((int)13, (int)bean2.stopOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)14, (int)bean2.destroyOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)-1, (int)bean1.stopOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)-1, (int)bean1.destroyOrder);
        context2 = this.assertInstall(1, "Name2");
        bean2 = (SimpleBeanWithLifecycle)context2.getTarget();
        PlainLifecycleDependencyTestCase.assertNotNull((Object)bean2);
        this.assertContext("Name1", ControllerState.INSTALLED);
        PlainLifecycleDependencyTestCase.assertEquals((int)15, (int)bean2.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)16, (int)bean2.startOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)9, (int)bean1.createOrder);
        PlainLifecycleDependencyTestCase.assertEquals((int)11, (int)bean1.startOrder);
    }

    public void plainLifecycleDependencyReinstall() throws Throwable {
        this.buildMetaData();
    }

    protected void buildMetaData() {
        AbstractBeanMetaData metaData1 = new AbstractBeanMetaData("Name1", SimpleBeanWithLifecycle.class.getName());
        AbstractBeanMetaData metaData2 = new AbstractBeanMetaData("Name2", SimpleBeanWithLifecycle.class.getName());
        HashSet<AbstractDependencyMetaData> depends = new HashSet<AbstractDependencyMetaData>();
        depends.add(new AbstractDependencyMetaData((Object)"Name1"));
        metaData2.setDepends(depends);
        this.setBeanMetaDatas(new BeanMetaData[]{metaData1, metaData2});
    }

    protected void setUp() throws Exception {
        super.setUp();
        SimpleBeanWithLifecycle.resetOrder();
    }
}

