/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.annotations.test.wb;

import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.Test;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.annotations.AbstractBeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.BeanAnnotationAdapter;
import org.jboss.kernel.plugins.annotations.ConstructorParameterAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.MetaDataAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.StartLifecycleAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.wb.WBInjectAnnotationPlugin;
import org.jboss.kernel.plugins.annotations.wb.WBInjectFieldAnnotationPlugin;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.test.kernel.annotations.support.AfterInstallVerifier;
import org.jboss.test.kernel.annotations.support.GBProvider;
import org.jboss.test.kernel.annotations.support.RBProvider;
import org.jboss.test.kernel.annotations.support.RGBProvider;
import org.jboss.test.kernel.annotations.support.RGProvider;
import org.jboss.test.kernel.annotations.support.WBTester;
import org.jboss.test.kernel.annotations.test.AbstractBeanAnnotationAdapterTest;

public class WBInjectionTestCase
extends AbstractBeanAnnotationAdapterTest {
    public WBInjectionTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        return WBInjectionTestCase.suite(WBInjectionTestCase.class);
    }

    protected BeanAnnotationAdapter getBeanAnnotationAdapterClass() {
        AbstractBeanAnnotationAdapter adapter = new AbstractBeanAnnotationAdapter();
        adapter.addAnnotationPlugin((MetaDataAnnotationPlugin)WBInjectFieldAnnotationPlugin.INSTANCE);
        adapter.addAnnotationPlugin((MetaDataAnnotationPlugin)WBInjectAnnotationPlugin.INSTANCE);
        WBInjectAnnotationPlugin paramAdapter = WBInjectAnnotationPlugin.INSTANCE;
        HashSet<WBInjectAnnotationPlugin> adapters = new HashSet<WBInjectAnnotationPlugin>();
        adapters.add(paramAdapter);
        adapter.addAnnotationPlugin((MetaDataAnnotationPlugin)new ConstructorParameterAnnotationPlugin(adapters));
        adapter.addAnnotationPlugin((MetaDataAnnotationPlugin)new StartLifecycleAnnotationPlugin(adapters));
        return adapter;
    }

    public void testInjection() throws Throwable {
        KernelController controller = this.getController();
        controller.install((BeanMetaData)new AbstractBeanMetaData("rg", RGProvider.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("rb", RBProvider.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("gb", GBProvider.class.getName()));
        this.runAnnotationsOnClass(WBTester.class, BeanAccessMode.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiple() throws Throwable {
        KernelController controller = this.getController();
        controller.install((BeanMetaData)new AbstractBeanMetaData("gb", GBProvider.class.getName()));
        controller.install((BeanMetaData)new AbstractBeanMetaData("rgb", RGBProvider.class.getName()));
        AfterInstallVerifier<WBTester> verifier = new AfterInstallVerifier<WBTester>(){

            @Override
            public void verifyContext(KernelControllerContext context) {
                Assert.assertEquals((Object)ControllerState.DESCRIBED, (Object)context.getState());
            }

            @Override
            public void verify(WBTester target) {
                Assert.assertNull((Object)target);
            }

            @Override
            public Class<WBTester> getTargetClass() {
                return WBTester.class;
            }
        };
        this.addVerifier(verifier);
        try {
            this.runAnnotationsOnClass(WBTester.class, BeanAccessMode.ALL);
        }
        finally {
            this.removeVerifier(WBTester.class);
        }
    }

    protected void doTestAfterInstall(Object target) {
        WBTester demander = (WBTester)target;
        WBInjectionTestCase.assertEquals((String)"RG", (String)(demander.getRg_provider() + ""));
        WBInjectionTestCase.assertEquals((String)"RB", (String)(demander.getRb_provider() + ""));
        WBInjectionTestCase.assertEquals((String)"GB", (String)(demander.getGb_provider1() + ""));
        WBInjectionTestCase.assertEquals((String)"GB", (String)(demander.getGb_provider2() + ""));
        WBInjectionTestCase.assertEquals((Object)demander.getGb_provider1(), (Object)demander.getGb_provider2());
    }
}

