/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.Set;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractSetMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.test.kernel.deployment.xml.test.AbstractXMLTest;

public class SetTestCase
extends AbstractXMLTest {
    protected AbstractSetMetaData getCollection(String name) throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean(name);
        Set properties = bean.getProperties();
        SetTestCase.assertNotNull((Object)properties);
        SetTestCase.assertEquals((int)1, (int)properties.size());
        PropertyMetaData property = (PropertyMetaData)properties.iterator().next();
        SetTestCase.assertNotNull((Object)property);
        ValueMetaData value = property.getValue();
        SetTestCase.assertNotNull((Object)property);
        SetTestCase.assertTrue((boolean)(value instanceof AbstractSetMetaData));
        return (AbstractSetMetaData)value;
    }

    public void testSet() throws Exception {
        AbstractSetMetaData collection = this.getCollection("Set.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
    }

    public void testSetWithClass() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithClass.xml");
        SetTestCase.assertEquals((String)"CollectionClass", (String)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
    }

    public void testSetWithElementClass() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithElementClass.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertEquals((String)"ElementClass", (String)collection.getElementType());
    }

    public void testSetWithValue() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithValue.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertValue("Value", this.getValue(collection));
    }

    public void testSetWithInjection() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithInjection.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertInjection(this.getValue(collection));
    }

    public void testSetWithCollection() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithCollection.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertCollection(this.getValue(collection));
    }

    public void testSetWithList() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithList.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertList(this.getValue(collection));
    }

    public void testSetWithSet() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithSet.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertSet(this.getValue(collection));
    }

    public void testSetWithArray() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithArray.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertArray(this.getValue(collection));
    }

    public void testSetWithMap() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithMap.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertMap(this.getValue(collection));
    }

    public void testSetWithNull() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithNull.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertNullValue(this.getValue(collection));
    }

    public void testSetWithThis() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithThis.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertThis(this.getValue(collection));
    }

    public void testSetWithWildcard() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithWildcard.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertWildcard(this.getValue(collection));
    }

    public void testSetWithBean() throws Exception {
        AbstractSetMetaData collection = this.getCollection("SetWithBean.xml");
        SetTestCase.assertNull((Object)collection.getType());
        SetTestCase.assertNull((Object)collection.getElementType());
        this.assertBean(this.getValue(collection));
    }

    protected ValueMetaData getValue(AbstractSetMetaData collection) {
        SetTestCase.assertEquals((int)1, (int)collection.size());
        return (ValueMetaData)collection.iterator().next();
    }

    public static Test suite() {
        return SetTestCase.suite(SetTestCase.class);
    }

    public SetTestCase(String name) {
        super(name);
    }

    protected SetTestCase(String name, boolean useClone) {
        super(name, useClone);
    }
}

