/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.config.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractCollectionMetaData;
import org.jboss.beans.metadata.plugins.AbstractListMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.plugins.StringValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.test.kernel.config.support.CustomCollection;
import org.jboss.test.kernel.config.support.MyObject;
import org.jboss.test.kernel.config.support.SimpleBean;
import org.jboss.test.kernel.config.support.UnmodifiableGetterBean;
import org.jboss.test.kernel.config.test.AbstractKernelConfigTest;

public class CollectionTestCase
extends AbstractKernelConfigTest {
    MyObject object1 = new MyObject("object1");
    MyObject object2 = new MyObject("object2");
    String string1 = "string1";
    String string2 = "string2";

    public static Test suite() {
        return CollectionTestCase.suite(CollectionTestCase.class);
    }

    public CollectionTestCase(String name) {
        super(name);
    }

    public CollectionTestCase(String name, boolean xmltest) {
        super(name, xmltest);
    }

    public void testSimpleCollectionFromObjects() throws Throwable {
        SimpleBean bean = this.simpleCollectionFromObjects();
        CollectionTestCase.assertNotNull((Object)bean);
        Collection<?> result = bean.getCollection();
        CollectionTestCase.assertNotNull((String)"Should be a collection", result);
        ArrayList<MyObject> expected = new ArrayList<MyObject>();
        expected.add(this.object1);
        expected.add(this.object2);
        expected.add(this.object2);
        expected.add(this.object1);
        CollectionTestCase.assertEquals(expected, result);
    }

    public SimpleBean simpleCollectionFromObjects() throws Throwable {
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        AbstractValueMetaData vmd1 = new AbstractValueMetaData((Object)this.object1);
        AbstractValueMetaData vmd2 = new AbstractValueMetaData((Object)this.object2);
        AbstractValueMetaData vmd3 = new AbstractValueMetaData((Object)this.object1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("collection", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure((BeanMetaData)bmd);
    }

    public void testSimpleCollectionFromStrings() throws Throwable {
        SimpleBean bean = this.simpleCollectionFromStrings();
        CollectionTestCase.assertNotNull((Object)bean);
        Collection<?> result = bean.getCollection();
        CollectionTestCase.assertNotNull((String)"Should be a collection", result);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        CollectionTestCase.assertEquals(expected, result);
    }

    protected SimpleBean simpleCollectionFromStrings() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("collection", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomCollectionExplicit() throws Throwable {
        SimpleBean bean = this.customCollectionExplicit();
        CollectionTestCase.assertNotNull((Object)bean);
        Collection<?> result = bean.getCollection();
        CollectionTestCase.assertNotNull((String)"Should be a collection", result);
        CollectionTestCase.assertTrue((String)("Not a CustomCollection: " + result.getClass()), (boolean)(result instanceof CustomCollection));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        CollectionTestCase.assertEquals(expected, result);
    }

    protected SimpleBean customCollectionExplicit() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setType(CustomCollection.class.getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("collection", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomCollectionFromSignature() throws Throwable {
        SimpleBean bean = this.customCollectionFromSignature();
        CollectionTestCase.assertNotNull((Object)bean);
        CustomCollection result = bean.getCustomCollection();
        CollectionTestCase.assertNotNull((String)"Should be a collection", (Object)result);
        CollectionTestCase.assertTrue((String)("Not a CustomCollection: " + result.getClass()), (boolean)(result instanceof CustomCollection));
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        CollectionTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean customCollectionFromSignature() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("customCollection", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCustomCollectionPreInstantiated() throws Throwable {
        SimpleBean bean = this.customCollectionPreInstantiated();
        CollectionTestCase.assertNotNull((Object)bean);
        CustomCollection result = bean.getPreInstantiatedCollection();
        CollectionTestCase.assertNotNull((String)"Should be a collection", (Object)result);
        CollectionTestCase.assertTrue((String)("Not a CustomCollection: " + result.getClass()), (boolean)(result instanceof CustomCollection));
        CollectionTestCase.assertTrue((String)"Not preinstantiated", (boolean)result.getPreInstantiated());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        CollectionTestCase.assertEquals(expected, (Object)result);
        Collection<?> setter = bean.setterCollection;
        CollectionTestCase.assertNotNull(setter);
        CollectionTestCase.assertFalse((String)"Empty setterCollection", (boolean)setter.isEmpty());
    }

    protected SimpleBean customCollectionPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setElementType("java.lang.String");
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("preInstantiatedCollection", (ValueMetaData)smd);
        properties.add(pmd);
        AbstractListMetaData lmd = new AbstractListMetaData();
        lmd.setElementType("java.lang.String");
        lmd.add((MetaDataVisitorNode)new StringValueMetaData("element"));
        AbstractPropertyMetaData pmd2 = new AbstractPropertyMetaData("setterCollection", (ValueMetaData)lmd);
        properties.add(pmd2);
        return (SimpleBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testUnmodifiableCollectionPreInstantiated() throws Throwable {
        UnmodifiableGetterBean bean = this.unmodifiableCollectionPreInstantiated();
        CollectionTestCase.assertNotNull((Object)bean);
        Collection result = bean.getCollection();
        CollectionTestCase.assertNotNull((String)"Should be a collection", (Object)result);
        ArrayList<String> expected = new ArrayList<String>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        CollectionTestCase.assertEquals((int)expected.size(), (int)result.size());
        Iterator i1 = expected.iterator();
        Iterator i2 = result.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            CollectionTestCase.assertEquals(i1.next(), i2.next());
        }
    }

    protected UnmodifiableGetterBean unmodifiableCollectionPreInstantiated() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelController controller = kernel.getController();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData("test1", UnmodifiableGetterBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setElementType("java.lang.String");
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("collection", (ValueMetaData)smd);
        pmd.setPreInstantiate(false);
        properties.add(pmd);
        return (UnmodifiableGetterBean)this.instantiate(controller, (BeanMetaData)bmd);
    }

    public void testCollectionWithValueTypeOverride() throws Throwable {
        SimpleBean bean = this.collectionWithValueTypeOverride();
        CollectionTestCase.assertNotNull((Object)bean);
        Collection<?> result = bean.getCollection();
        CollectionTestCase.assertNotNull((String)"Should be a collection", result);
        CollectionTestCase.assertTrue((String)("Not a CustomCollection: " + result.getClass()), (boolean)(result instanceof CustomCollection));
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        expected.add(new Integer(1));
        CollectionTestCase.assertEquals(expected, result);
    }

    protected SimpleBean collectionWithValueTypeOverride() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd4 = new StringValueMetaData("1");
        vmd4.setConfigurator(configurator);
        vmd4.setType("java.lang.Integer");
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setType(CustomCollection.class.getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        smd.add((MetaDataVisitorNode)vmd4);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("collection", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCollectionInjectOnObject() throws Throwable {
        SimpleBean bean = this.collectionInjectOnObject();
        CollectionTestCase.assertNotNull((Object)bean);
        Object result = bean.getAnObject();
        CollectionTestCase.assertNotNull((String)"Should be a collection", (Object)result);
        CollectionTestCase.assertTrue((String)("Not a CustomCollection: " + result.getClass()), (boolean)(result instanceof ArrayList));
        ArrayList<Object> expected = new ArrayList<Object>();
        expected.add(this.string1);
        expected.add(this.string2);
        expected.add(this.string2);
        expected.add(this.string1);
        expected.add(new Integer(1));
        CollectionTestCase.assertEquals(expected, (Object)result);
    }

    protected SimpleBean collectionInjectOnObject() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd4 = new StringValueMetaData("1");
        vmd4.setConfigurator(configurator);
        vmd4.setType("java.lang.Integer");
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setType(CustomCollection.class.getName());
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        smd.add((MetaDataVisitorNode)vmd4);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("anObject", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCollectionNotACollection() throws Throwable {
        try {
            this.collectionNotACollection();
            CollectionTestCase.fail((String)"Expected a failure trying to set a collection on a non collection attribute");
        }
        catch (Exception expected) {
            this.checkCollectionNotACollectionException(expected);
        }
    }

    protected void checkCollectionNotACollectionException(Exception exception) {
        CollectionTestCase.checkThrowable(ClassCastException.class, (Throwable)exception);
    }

    protected SimpleBean collectionNotACollection() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("AString", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }

    public void testCollectionIsInterface() throws Throwable {
        try {
            this.collectionIsInterface();
            CollectionTestCase.fail((String)"Expected a failure trying to use an interface for the collection type");
        }
        catch (Exception expected) {
            this.checkCollectionIsInterfaceException(expected);
        }
    }

    protected void checkCollectionIsInterfaceException(Exception exception) {
        CollectionTestCase.checkThrowable(IllegalArgumentException.class, (Throwable)exception);
    }

    protected SimpleBean collectionIsInterface() throws Throwable {
        Kernel kernel = this.bootstrap();
        KernelConfigurator configurator = kernel.getConfigurator();
        AbstractBeanMetaData bmd = new AbstractBeanMetaData(SimpleBean.class.getName());
        HashSet<AbstractPropertyMetaData> properties = new HashSet<AbstractPropertyMetaData>();
        bmd.setProperties(properties);
        StringValueMetaData vmd1 = new StringValueMetaData(this.string1);
        StringValueMetaData vmd2 = new StringValueMetaData(this.string2);
        StringValueMetaData vmd3 = new StringValueMetaData(this.string1);
        AbstractCollectionMetaData smd = new AbstractCollectionMetaData();
        smd.setType("java.util.Collection");
        smd.setElementType("java.lang.String");
        smd.setConfigurator(configurator);
        smd.add((MetaDataVisitorNode)vmd1);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd2);
        smd.add((MetaDataVisitorNode)vmd3);
        AbstractPropertyMetaData pmd = new AbstractPropertyMetaData("collection", (ValueMetaData)smd);
        properties.add(pmd);
        return (SimpleBean)this.instantiateAndConfigure(configurator, (BeanMetaData)bmd);
    }
}

