/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.kernel.deployment.xml.test;

import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.Test;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.spi.LifecycleMetaData;
import org.jboss.test.kernel.deployment.xml.support.Annotation1;
import org.jboss.test.kernel.deployment.xml.support.Annotation2;
import org.jboss.test.kernel.deployment.xml.support.Annotation3;
import org.jboss.test.kernel.deployment.xml.test.AbstractMCTest;

public class LifecycleJaxbTestCase
extends AbstractMCTest {
    protected LifecycleMetaData getLifecycle() throws Exception {
        AbstractBeanMetaData bean = this.unmarshalBean();
        LifecycleMetaData lifecycle = bean.getCreate();
        LifecycleJaxbTestCase.assertNotNull((Object)lifecycle);
        return lifecycle;
    }

    public void testLifecycle() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle();
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getAnnotations());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithMethod() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle();
        LifecycleJaxbTestCase.assertEquals((String)"Method", (String)lifecycle.getMethodName());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getAnnotations());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithIgnored() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle();
        LifecycleJaxbTestCase.assertTrue((boolean)lifecycle.isIgnored());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getAnnotations());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithAnnotation() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle();
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        this.assertAnnotations(expected, lifecycle.getAnnotations());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithAnnotations() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle();
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getMethodName());
        HashSet<String> expected = new HashSet<String>();
        expected.add(Annotation1.class.getName());
        expected.add(Annotation2.class.getName());
        expected.add(Annotation3.class.getName());
        this.assertAnnotations(expected, lifecycle.getAnnotations());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getParameters());
    }

    public void testLifecycleWithParameter() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle();
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        this.assertParameters(expected, lifecycle.getParameters());
    }

    public void testLifecycleWithParameters() throws Exception {
        LifecycleMetaData lifecycle = this.getLifecycle();
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getMethodName());
        LifecycleJaxbTestCase.assertNull((Object)lifecycle.getAnnotations());
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("Parameter1");
        expected.add("Parameter2");
        expected.add("Parameter3");
        this.assertParameters(expected, lifecycle.getParameters());
    }

    public static Test suite() {
        return LifecycleJaxbTestCase.suite(LifecycleJaxbTestCase.class);
    }

    public LifecycleJaxbTestCase(String name) {
        super(name);
    }
}

