/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reliance.identity;

import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.logging.Logger;
import org.jboss.reliance.identity.Configuration;
import org.jboss.reliance.identity.SimpleGroup;
import org.jboss.reliance.identity.SimplePrincipal;

public class Identity {
    protected static Logger log = Logger.getLogger(Identity.class);
    public static final String ROLES_GROUP = "Roles";
    private String username;
    private String password;
    private Principal principal;
    private Subject subject;
    private String jaasConfigName = null;
    private Configuration configuration;
    private boolean authenticating = false;
    private List<String> preAuthenticationRoles = new ArrayList<String>();

    public void create() {
        this.subject = new Subject();
    }

    public boolean login() {
        try {
            this.authenticate();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Login successful for: " + this.getUsername()));
            }
            return true;
        }
        catch (LoginException ex) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Login failed for: " + this.getUsername()), (Throwable)ex);
            }
            return false;
        }
    }

    public void logout() {
        this.principal = null;
    }

    public boolean isCredentialsSet() {
        return this.username != null && this.password != null;
    }

    public void quietLogin() {
        try {
            if (this.isCredentialsSet()) {
                this.authenticate();
            }
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    public void authenticate() throws LoginException {
        if (!this.isLoggedIn()) {
            this.authenticate(this.getLoginContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(LoginContext loginContext) throws LoginException {
        try {
            this.authenticating = true;
            this.preAuthenticate();
            loginContext.login();
            this.postAuthenticate();
        }
        finally {
            this.authenticating = false;
        }
    }

    protected void preAuthenticate() {
        this.unAuthenticate();
        this.preAuthenticationRoles.clear();
    }

    protected void postAuthenticate() {
        for (Principal p : this.getSubject().getPrincipals()) {
            if (p instanceof Group || this.principal != null) continue;
            this.principal = p;
            break;
        }
        if (!this.preAuthenticationRoles.isEmpty() && this.isLoggedIn()) {
            for (String role : this.preAuthenticationRoles) {
                this.addRole(role);
            }
            this.preAuthenticationRoles.clear();
        }
        this.password = null;
    }

    protected void unAuthenticate() {
        this.principal = null;
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            this.getSubject().getPrincipals().remove(sg);
            break;
        }
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn(false);
    }

    public boolean isLoggedIn(boolean attemptLogin) {
        if (!this.authenticating && attemptLogin && this.getPrincipal() == null && this.isCredentialsSet()) {
            this.quietLogin();
        }
        return this.getPrincipal() != null;
    }

    public boolean hasRole(String role) {
        this.isLoggedIn(true);
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.isMember((Principal)new SimplePrincipal(role));
        }
        return false;
    }

    public boolean addRole(String role) {
        if (!this.isLoggedIn()) {
            this.preAuthenticationRoles.add(role);
            return false;
        }
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.addMember((Principal)new SimplePrincipal(role));
        }
        SimpleGroup roleGroup = new SimpleGroup(ROLES_GROUP);
        roleGroup.addMember(new SimplePrincipal(role));
        this.getSubject().getPrincipals().add((Principal)((Object)roleGroup));
        return true;
    }

    public void removeRole(String role) {
        block0: for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            Enumeration e = sg.members();
            while (e.hasMoreElements()) {
                Principal member = (Principal)e.nextElement();
                if (!member.getName().equals(role)) continue;
                sg.removeMember(member);
                continue block0;
            }
        }
    }

    protected LoginContext getLoginContext() throws LoginException {
        if (this.getJaasConfigName() != null) {
            return new LoginContext(this.getJaasConfigName(), this.getSubject(), this.getDefaultCallbackHandler());
        }
        return new LoginContext("default", this.getSubject(), this.getDefaultCallbackHandler(), this.configuration.getConfiguration());
    }

    protected CallbackHandler getDefaultCallbackHandler() {
        return new CallbackHandler(){

            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        ((NameCallback)callback).setName(Identity.this.getUsername());
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        ((PasswordCallback)callback).setPassword(Identity.this.getPassword() != null ? Identity.this.getPassword().toCharArray() : null);
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback, "Unsupported callback");
                }
            }
        };
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getJaasConfigName() {
        return this.jaasConfigName;
    }

    public void setJaasConfigName(String jaasConfigName) {
        this.jaasConfigName = jaasConfigName;
    }

    @Inject
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

