/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reliance.drools.core;

import java.io.Reader;
import java.io.StringReader;
import java.util.UUID;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.rule.Package;
import org.jboss.beans.metadata.api.annotations.Constructor;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.reliance.drools.core.PackageWrapper;
import org.w3c.dom.Element;

public class PackageGenerator {
    private KernelController controller;
    private String name;
    private String fromDRL;
    private Element fromXML;
    private String dslTemplate;
    private PackageBuilderConfiguration configuration;
    private String uuidName;

    @Constructor
    public PackageGenerator(@Inject(bean="jboss.kernel:service=KernelController") KernelController controller) {
        this.controller = controller;
    }

    public void start() throws Throwable {
        PackageBuilder builder = new PackageBuilder(this.configuration);
        StringReader dslReader = null;
        if (this.dslTemplate != null) {
            dslReader = new StringReader(this.dslTemplate);
        }
        if (this.fromDRL != null) {
            StringReader drlReader = new StringReader(this.fromDRL);
            if (dslReader != null) {
                builder.addPackageFromDrl((Reader)drlReader, (Reader)dslReader);
            } else {
                builder.addPackageFromDrl((Reader)drlReader);
            }
        }
        if (this.fromXML != null) {
            StringReader xmlReader = new StringReader(this.fromXML.toString());
            builder.addPackageFromXml((Reader)xmlReader);
        }
        this.uuidName = UUID.randomUUID().toString();
        BeanMetaDataBuilder beanBuilder = BeanMetaDataBuilderFactory.createBuilder((String)this.uuidName, (String)PackageWrapper.class.getName());
        beanBuilder.addConstructorParameter(String.class.getName(), (Object)this.name).addConstructorParameter(Package.class.getName(), (Object)builder.getPackage());
        this.controller.install(beanBuilder.getBeanMetaData());
    }

    public void stop() {
        this.controller.uninstall((Object)this.uuidName);
        this.uuidName = null;
    }

    public void setConfiguration(PackageBuilderConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFromDRL(String fromDRL) {
        this.fromDRL = fromDRL;
    }

    public void setFromXML(Element fromXML) {
        this.fromXML = fromXML;
    }

    public void setDslTemplate(String dslTemplate) {
        this.dslTemplate = dslTemplate;
    }
}

