/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reliance.drools.core.aspects;

import java.lang.reflect.Method;
import org.drools.Agenda;
import org.drools.WorkingMemory;
import org.drools.spi.AgendaFilter;
import org.jboss.aop.joinpoint.MethodInvocation;

public class FireAllRulesAspect {
    private AgendaFilter filter;
    private Integer limit;

    protected boolean shouldFileAllRules(Method method, Object[] args) {
        return !method.getName().startsWith("fireAllRules");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object target = invocation.getTargetObject();
        if (!(target instanceof WorkingMemory)) {
            throw new IllegalArgumentException("Target must implement WorkingMemory.");
        }
        WorkingMemory delegate = (WorkingMemory)target;
        Object result = invocation.invokeNext();
        if (this.shouldFileAllRules(invocation.getActualMethod(), invocation.getArguments())) {
            if (this.filter != null && this.limit != null) {
                delegate.fireAllRules(this.filter, this.limit.intValue());
            } else if (this.filter != null) {
                delegate.fireAllRules(this.filter);
            } else if (this.limit != null) {
                delegate.fireAllRules(this.limit.intValue());
            } else {
                delegate.fireAllRules();
            }
            Agenda agenda = delegate.getAgenda();
        }
        return result;
    }

    public void setFilter(AgendaFilter filter) {
        this.filter = filter;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }
}

