/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.spring.annotations;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.api.model.FromContext;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractPropertyMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.annotations.ClassAnnotationPlugin;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.spring.annotations.SpringBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanAnnotationPlugin
extends ClassAnnotationPlugin<SpringBean> {
    private static final String BNAI = "org.springframework.beans.factory.BeanNameAware";
    private static final String BNP = "beanName";

    public SpringBeanAnnotationPlugin() {
        super(SpringBean.class);
    }

    protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, SpringBean annotation, BeanMetaData metaData) throws Throwable {
        PropertyMetaData property = this.findBeanNameAwareInterface(info, metaData);
        return property != null ? Collections.singletonList(property) : null;
    }

    protected PropertyMetaData findBeanNameAwareInterface(ClassInfo info, BeanMetaData metaData) {
        ClassInfo superInfo;
        InterfaceInfo[] interfaces = info.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            for (InterfaceInfo anInterface : interfaces) {
                String name = anInterface.getName();
                if (BNAI.equals(name)) {
                    AbstractInjectionValueMetaData injectionMetaData = new AbstractInjectionValueMetaData();
                    injectionMetaData.setFromContext(FromContext.NAME);
                    AbstractPropertyMetaData beanNameProperty = new AbstractPropertyMetaData(BNP, (ValueMetaData)injectionMetaData);
                    HashSet<AbstractPropertyMetaData> properties = metaData.getProperties();
                    if (properties == null) {
                        properties = new HashSet<AbstractPropertyMetaData>();
                        AbstractBeanMetaData abmd = this.checkIfNotAbstractBeanMetaDataSpecific(metaData);
                        abmd.setProperties(properties);
                    }
                    properties.add(beanNameProperty);
                    return beanNameProperty;
                }
                PropertyMetaData property = this.findBeanNameAwareInterface((ClassInfo)anInterface, metaData);
                if (property == null) continue;
                return property;
            }
        }
        if ((superInfo = info.getSuperclass()) != null) {
            return this.findBeanNameAwareInterface(superInfo, metaData);
        }
        return null;
    }

    protected boolean isMetaDataAlreadyPresent(ClassInfo info, SpringBean annotation, BeanMetaData beanMetaData) {
        Set properties = beanMetaData.getProperties();
        if (properties != null && !properties.isEmpty()) {
            for (PropertyMetaData property : properties) {
                if (!BNP.equals(property.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

