/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.migration.core.AbstractServerProvider;
import org.jboss.migration.core.ManifestProductInfo;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.eap.EAP6Server;

public class EAP6ServerProvider
extends AbstractServerProvider {
    protected ProductInfo getProductInfo(Path baseDir) throws IllegalArgumentException, IOException {
        Path manifestPath = EAP6Server.getModulesSystemLayersBaseDir(baseDir).resolve("org").resolve("jboss").resolve("as").resolve("product").resolve("eap").resolve("dir").resolve("META-INF").resolve("MANIFEST.MF");
        ManifestProductInfo productInfo = ManifestProductInfo.from((Path)manifestPath);
        return productInfo;
    }

    protected String getProductNameRegex() {
        return "EAP";
    }

    protected String getProductVersionRegex() {
        return "6\\..*";
    }

    protected Server constructServer(ProductInfo productInfo, Path baseDir) {
        return new EAP6Server(productInfo, baseDir);
    }

    public String getName() {
        return "EAP 6.x";
    }
}

