/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.standalone;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.wildfly.core.embedded.EmbeddedServerFactory;
import org.wildfly.core.embedded.ServerStartException;
import org.wildfly.core.embedded.StandaloneServer;

public class EmbeddedWildFly10StandaloneServer
implements WildFly10StandaloneServer {
    private final String config;
    private StandaloneServer standaloneServer;
    private final WildFly10Server server;

    public EmbeddedWildFly10StandaloneServer(String config, WildFly10Server server) {
        this.config = config;
        this.server = server;
    }

    @Override
    public synchronized void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("server started");
        }
        String[] cmds = new String[]{"--server-config=" + this.config, "--admin-only"};
        this.standaloneServer = EmbeddedServerFactory.create((String)this.server.getBaseDir().toString(), null, null, (String[])cmds);
        try {
            this.standaloneServer.start();
        }
        catch (ServerStartException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted()) {
            throw new IllegalStateException("server not started");
        }
        this.standaloneServer.stop();
        this.standaloneServer = null;
    }

    @Override
    public boolean isStarted() {
        return this.standaloneServer != null;
    }

    @Override
    public Set<String> getExtensions() throws IOException {
        ModelNode op = Util.createEmptyOperation((String)"read-children-names", null);
        op.get("child-type").set("extension");
        ModelNode opResult = this.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Get Extensions Op result %s", (Object)opResult.toString());
        HashSet<String> result = new HashSet<String>();
        for (ModelNode resultNode : opResult.get("result").asList()) {
            result.add(resultNode.asString());
        }
        return result;
    }

    @Override
    public WildFly10Server getServer() {
        return this.server;
    }

    @Override
    public ModelNode getSubsystem(String subsystem) throws IOException {
        if (!this.getSubsystems().contains(subsystem)) {
            return null;
        }
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem)});
        ModelNode op = Util.createEmptyOperation((String)"read-resource", (PathAddress)address);
        op.get("recursive").set(true);
        ModelNode result = this.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Op result %s", (Object)result.toString());
        return result.get("result");
    }

    @Override
    public Set<String> getSubsystems() throws IOException {
        ModelNode op = Util.createEmptyOperation((String)"read-children-names", null);
        op.get("child-type").set("subsystem");
        ModelNode opResult = this.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Get subsystems Op result %s", (Object)opResult.toString());
        HashSet<String> result = new HashSet<String>();
        for (ModelNode resultNode : opResult.get("result").asList()) {
            result.add(resultNode.asString());
        }
        return result;
    }

    @Override
    public List<ModelNode> getSecurityRealms() throws IOException {
        ModelNode op = Util.createEmptyOperation((String)"read-children-resources", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"core-service", (String)"management")}));
        op.get("child-type").set("security-realm");
        op.get("recursive").set(true);
        ModelNode opResult = this.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Get security realms Op result %s", (Object)opResult.toString());
        return opResult.get("result").asList();
    }

    @Override
    public void removeSubsystem(String subsystem) throws IOException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem)});
        ModelNode op = Util.createRemoveOperation((PathAddress)address);
        this.executeManagementOperation(op);
    }

    @Override
    public void removeExtension(String extension) throws IOException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"extension", (String)extension)});
        ModelNode op = Util.createRemoveOperation((PathAddress)address);
        this.executeManagementOperation(op);
    }

    @Override
    public Path resolvePath(String pathName) throws IOException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"path", (String)pathName)});
        ModelNode op = Util.createEmptyOperation((String)"read-resource", (PathAddress)address);
        ModelNode opResult = this.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Resolve path Op result %s", (Object)opResult.toString());
        String path = opResult.get("result").get("path").asString();
        if (!opResult.get("result").hasDefined("relative-to")) {
            return Paths.get(path, new String[0]);
        }
        return this.resolvePath(opResult.get("result").get("relative-to").asString()).resolve(path);
    }

    private void processResult(ModelNode result) {
        if (!"success".equals(result.get("outcome").asString())) {
            throw new RuntimeException(result.get("failure-description").asString());
        }
    }

    @Override
    public ModelNode executeManagementOperation(ModelNode operation) throws IOException {
        ModelNode result = this.standaloneServer.getModelControllerClient().execute(operation);
        this.processResult(result);
        return result;
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return this.standaloneServer.getModelControllerClient();
    }
}

