/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.standalone.config;

import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerPath;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;

public class WildFly10StandaloneConfigFileDeploymentsMigration<S extends Server> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ServerPath<S> source, WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        ServerMigrationLogger.ROOT_LOGGER.debug((Object)"Migrating deployments...");
        boolean targetStarted = target.isStarted();
        if (!targetStarted) {
            target.start();
        }
        try {
            for (ModelNode deployment : this.getDeployments(target)) {
                this.migrateDeployment(deployment, source, target, context);
            }
        }
        finally {
            if (!targetStarted) {
                target.stop();
            }
            ServerMigrationLogger.ROOT_LOGGER.info((Object)"Deployments migration done.");
        }
    }

    private List<ModelNode> getDeployments(WildFly10StandaloneServer target) throws IOException {
        ModelNode op = Util.createEmptyOperation((String)"read-children-resources", (PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[0]));
        op.get("child-type").set("deployment");
        op.get("recursive").set(true);
        ModelNode result = target.getModelControllerClient().execute(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Op result: %s", (Object)result.asString());
        if (!"success".equals(result.get("outcome").asString())) {
            throw new RuntimeException("Failed to retrieve deployments from server.");
        }
        return result.get("result").asList();
    }

    protected void migrateDeployment(ModelNode deployment, ServerPath<S> source, WildFly10StandaloneServer target, ServerMigrationContext context) throws IOException {
        Property deploymentAsProperty = deployment.asProperty();
        String deploymentName = deploymentAsProperty.getName();
        ModelNode op = Util.createRemoveOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"deployment", (String)deploymentName)}));
        target.executeManagementOperation(op);
        ServerMigrationLogger.ROOT_LOGGER.infof("Removed deployment %s", (Object)deploymentName);
    }
}

