/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.standalone.config;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerPath;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.WildFly10Server;
import org.jboss.migration.wfly10.standalone.EmbeddedWildFly10StandaloneServer;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;

public abstract class WildFly10StandaloneConfigFileMigration<S extends Server> {
    public void run(ServerPath<S> sourceConfig, WildFly10Server target, ServerMigrationContext context) throws IOException {
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        ServerMigrationLogger.ROOT_LOGGER.infof("Migrating standalone server configuration %s", (Object)sourceConfig.getPath());
        this.copyFileToTargetServer(sourceConfig.getPath(), target, context);
        WildFly10StandaloneServer standaloneServer = this.startEmbeddedServer(sourceConfig.getPath(), target, context);
        this.run(sourceConfig, standaloneServer, context);
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        standaloneServer.stop();
        ServerMigrationLogger.ROOT_LOGGER.info((Object)"Standalone server configuration file migration done.");
    }

    protected abstract void run(ServerPath<S> var1, WildFly10StandaloneServer var2, ServerMigrationContext var3) throws IOException;

    protected void copyFileToTargetServer(Path source, WildFly10Server targetServer, ServerMigrationContext context) throws IOException {
        Path target = targetServer.getStandaloneConfigurationDir().resolve(source.getFileName());
        ServerMigrationLogger.ROOT_LOGGER.debugf("Source server configuration file is %s", (Object)source);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Target server configuration file is %s", (Object)target);
        context.getMigrationFiles().copy(source, target);
        ServerMigrationLogger.ROOT_LOGGER.infof("Server configuration file %s copied to %s", (Object)source, (Object)target);
    }

    protected WildFly10StandaloneServer startEmbeddedServer(Path source, WildFly10Server target, ServerMigrationContext context) throws IOException {
        context.getConsoleWrapper().printf("%n%n", new Object[0]);
        String config = source.getFileName().toString();
        ServerMigrationLogger.ROOT_LOGGER.infof("Starting server server configuration %s", (Object)config);
        EmbeddedWildFly10StandaloneServer wildFly10StandaloneServer = new EmbeddedWildFly10StandaloneServer(config, target);
        wildFly10StandaloneServer.start();
        return wildFly10StandaloneServer;
    }
}

