/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class MigrateLegacySubsystem
implements WildFly10SubsystemMigrationTask {
    public static final MigrateLegacySubsystem INSTANCE = new MigrateLegacySubsystem();

    private MigrateLegacySubsystem() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (!server.getSubsystems().contains(subsystem.getName())) {
            return;
        }
        ServerMigrationLogger.ROOT_LOGGER.debugf("Migrating subsystem %s...", (Object)subsystem.getName());
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName())});
        ModelNode op = Util.createEmptyOperation((String)"migrate", (PathAddress)address);
        ModelNode result = server.getModelControllerClient().execute(op);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Op result: %s", (Object)result.asString());
        if (!"success".equals(result.get("outcome").asString())) {
            throw new RuntimeException("Subsystem " + subsystem.getName() + " migration failed: " + result.get("migration-error").asString());
        }
        ArrayList<String> migrateWarnings = new ArrayList<String>();
        if (result.get("result").hasDefined("migration-warnings")) {
            for (ModelNode modelNode : result.get("result").get("migration-warnings").asList()) {
                migrateWarnings.add(modelNode.asString());
            }
        }
        this.postMigrate(migrateWarnings, server, context);
        if (migrateWarnings.isEmpty()) {
            ServerMigrationLogger.ROOT_LOGGER.infof("Subsystem %s migrated.", (Object)subsystem.getName());
        } else {
            ServerMigrationLogger.ROOT_LOGGER.infof("Subsystem %s migrated with warnings: %s", (Object)subsystem.getName(), migrateWarnings);
        }
        if (server.getSubsystems().contains(subsystem.getName())) {
            server.removeSubsystem(subsystem.getName());
            ServerMigrationLogger.ROOT_LOGGER.debugf("Subsystem %s removed after migration.", (Object)subsystem.getName());
        }
    }

    protected void postMigrate(List<String> migrationWarnings, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
    }
}

