/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;

public class WildFly10Extension {
    private final String name;
    protected final List<WildFly10Subsystem> subsystems;

    public WildFly10Extension(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.subsystems = new ArrayList<WildFly10Subsystem>();
    }

    public String getName() {
        return this.name;
    }

    public List<WildFly10Subsystem> getSubsystems() {
        return Collections.unmodifiableList(this.subsystems);
    }

    public void migrate(WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        for (WildFly10Subsystem subsystem : this.subsystems) {
            subsystem.migrate(server, context);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildFly10Extension that = (WildFly10Extension)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

