/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.ee;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddConcurrencyUtilitiesDefaultConfig
implements WildFly10SubsystemMigrationTask {
    public static final String DEFAULT_CONTEXT_SERVICE_JNDI_NAME = "java:jboss/ee/concurrency/context/default";
    public static final String DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME = "java:jboss/ee/concurrency/factory/default";
    public static final String DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME = "java:jboss/ee/concurrency/executor/default";
    public static final String DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME = "java:jboss/ee/concurrency/scheduler/default";
    public static final AddConcurrencyUtilitiesDefaultConfig INSTANCE = new AddConcurrencyUtilitiesDefaultConfig();

    private AddConcurrencyUtilitiesDefaultConfig() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        PathElement subsystemPathElement = PathElement.pathElement((String)"subsystem", (String)subsystem.getName());
        PathAddress defaultContextServicePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{subsystemPathElement, PathElement.pathElement((String)"context-service", (String)"default")});
        ModelNode defaultContextServiceAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultContextServicePathAddress);
        defaultContextServiceAddOp.get("jndi-name").set(DEFAULT_CONTEXT_SERVICE_JNDI_NAME);
        defaultContextServiceAddOp.get("use-transaction-setup-provider").set(true);
        server.executeManagementOperation(defaultContextServiceAddOp);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Default ContextService added to subsystem EE configuration.", new Object[0]);
        PathAddress defaultManagedThreadFactoryPathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{subsystemPathElement, PathElement.pathElement((String)"managed-thread-factory", (String)"default")});
        ModelNode defaultManagedThreadFactoryAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultManagedThreadFactoryPathAddress);
        defaultManagedThreadFactoryAddOp.get("jndi-name").set(DEFAULT_MANAGED_THREAD_FACTORY_JNDI_NAME);
        defaultManagedThreadFactoryAddOp.get("context-service").set("default");
        defaultManagedThreadFactoryAddOp.get("priority").set(5);
        server.executeManagementOperation(defaultManagedThreadFactoryAddOp);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Default ManagedThreadFactory added to subsystem EE configuration.", new Object[0]);
        PathAddress defaultManagedExecutorServicePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{subsystemPathElement, PathElement.pathElement((String)"managed-executor-service", (String)"default")});
        ModelNode defaultManagedExecutorServiceAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultManagedExecutorServicePathAddress);
        defaultManagedExecutorServiceAddOp.get("jndi-name").set(DEFAULT_MANAGED_EXECUTOR_SERVICE_JNDI_NAME);
        defaultManagedExecutorServiceAddOp.get("context-service").set("default");
        defaultManagedExecutorServiceAddOp.get("hung-task-threshold").set(60000L);
        defaultManagedExecutorServiceAddOp.get("keepalive-time").set(5000L);
        defaultManagedExecutorServiceAddOp.get("long-running-tasks").set(false);
        defaultManagedExecutorServiceAddOp.get("reject-policy").set("ABORT");
        server.executeManagementOperation(defaultManagedExecutorServiceAddOp);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Default ManagedExecutorService added to subsystem EE configuration.", new Object[0]);
        PathAddress defaultManagedScheduledExecutorServicePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{subsystemPathElement, PathElement.pathElement((String)"managed-scheduled-executor-service", (String)"default")});
        ModelNode defaultManagedScheduledExecutorServiceAddOp = Util.createEmptyOperation((String)"add", (PathAddress)defaultManagedScheduledExecutorServicePathAddress);
        defaultManagedScheduledExecutorServiceAddOp.get("jndi-name").set(DEFAULT_MANAGED_SCHEDULED_EXECUTOR_SERVICE_JNDI_NAME);
        defaultManagedScheduledExecutorServiceAddOp.get("context-service").set("default");
        defaultManagedScheduledExecutorServiceAddOp.get("hung-task-threshold").set(60000L);
        defaultManagedScheduledExecutorServiceAddOp.get("keepalive-time").set(3000L);
        defaultManagedScheduledExecutorServiceAddOp.get("long-running-tasks").set(false);
        defaultManagedScheduledExecutorServiceAddOp.get("reject-policy").set("ABORT");
        server.executeManagementOperation(defaultManagedScheduledExecutorServiceAddOp);
        ServerMigrationLogger.ROOT_LOGGER.debugf("Default ManagedScheduledExecutorService added to subsystem EE configuration.", new Object[0]);
        ServerMigrationLogger.ROOT_LOGGER.infof("EE Concurrency Utilities added.", new Object[0]);
    }
}

