/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.ejb3;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddInfinispanPassivationStoreAndDistributableCache
implements WildFly10SubsystemMigrationTask {
    public static final AddInfinispanPassivationStoreAndDistributableCache INSTANCE = new AddInfinispanPassivationStoreAndDistributableCache();
    private static final String CLUSTER_PASSIVATION_STORE = "cluster-passivation-store";
    private static final String FILE_PASSIVATION_STORE = "file-passivation-store";
    private static final String FILE_PASSIVATION_STORE_NAME = "file";
    private static final String PASSIVATION_STORE = "passivation-store";
    private static final String PASSIVATION_STORE_NAME = "infinispan";
    private static final String CACHE_CONTAINER_ATTR_NAME = "cache-container";
    private static final String CACHE_CONTAINER_ATTR_VALUE = "ejb";
    private static final String MAX_SIZE_ATTR_NAME = "max-size";
    private static final String MAX_SIZE_ATTR_VALUE = "10000";
    private static final String CACHE = "cache";
    private static final String CACHE_NAME_DISTRIBUTABLE = "distributable";
    private static final String CACHE_NAME_PASSIVATING = "passivating";
    private static final String CACHE_NAME_CLUSTERED = "clustered";
    private static final String ALIASES_ATTR_NAME = "aliases";
    private static final String[] ALIASES_ATTR_VALUE = new String[]{"passivating", "clustered"};

    private AddInfinispanPassivationStoreAndDistributableCache() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        if (!config.hasDefined(new String[]{PASSIVATION_STORE, PASSIVATION_STORE_NAME})) {
            ModelNode filePassivationStoreRemoveperation;
            PathAddress filePassivationStorePathAddress;
            if (config.hasDefined(new String[]{FILE_PASSIVATION_STORE, FILE_PASSIVATION_STORE_NAME})) {
                filePassivationStorePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)FILE_PASSIVATION_STORE, (String)FILE_PASSIVATION_STORE_NAME)});
                filePassivationStoreRemoveperation = Util.createRemoveOperation((PathAddress)filePassivationStorePathAddress);
                server.executeManagementOperation(filePassivationStoreRemoveperation);
                ServerMigrationLogger.ROOT_LOGGER.infof("Legacy file passivation store removed from EJB3 subsystem configuration.", new Object[0]);
            }
            if (config.hasDefined(new String[]{CLUSTER_PASSIVATION_STORE, PASSIVATION_STORE_NAME})) {
                filePassivationStorePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)CLUSTER_PASSIVATION_STORE, (String)PASSIVATION_STORE_NAME)});
                filePassivationStoreRemoveperation = Util.createRemoveOperation((PathAddress)filePassivationStorePathAddress);
                server.executeManagementOperation(filePassivationStoreRemoveperation);
                ServerMigrationLogger.ROOT_LOGGER.infof("Legacy 'clustered' passivation store removed from EJB3 subsystem configuration.", new Object[0]);
            }
            PathAddress passivationStorePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)PASSIVATION_STORE, (String)PASSIVATION_STORE_NAME)});
            ModelNode passivationStoreAddOperation = Util.createAddOperation((PathAddress)passivationStorePathAddress);
            passivationStoreAddOperation.get(CACHE_CONTAINER_ATTR_NAME).set(CACHE_CONTAINER_ATTR_VALUE);
            passivationStoreAddOperation.get(MAX_SIZE_ATTR_NAME).set(MAX_SIZE_ATTR_VALUE);
            server.executeManagementOperation(passivationStoreAddOperation);
            ServerMigrationLogger.ROOT_LOGGER.infof("Infinispan passivation store added to EJB3 subsystem configuration.", new Object[0]);
        }
        if (!config.hasDefined(new String[]{CACHE, CACHE_NAME_DISTRIBUTABLE})) {
            ModelNode cacheRemoveOperation;
            PathAddress cachePathAddress;
            if (config.hasDefined(new String[]{CACHE, CACHE_NAME_PASSIVATING})) {
                cachePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)CACHE, (String)CACHE_NAME_PASSIVATING)});
                cacheRemoveOperation = Util.createRemoveOperation((PathAddress)cachePathAddress);
                server.executeManagementOperation(cacheRemoveOperation);
                ServerMigrationLogger.ROOT_LOGGER.infof("Legacy 'passivating' cache removed from EJB3 subsystem configuration.", new Object[0]);
            }
            if (config.hasDefined(new String[]{CACHE, CACHE_NAME_CLUSTERED})) {
                cachePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)CACHE, (String)CACHE_NAME_CLUSTERED)});
                cacheRemoveOperation = Util.createRemoveOperation((PathAddress)cachePathAddress);
                server.executeManagementOperation(cacheRemoveOperation);
                ServerMigrationLogger.ROOT_LOGGER.infof("Legacy 'clustered' cache removed from EJB3 subsystem configuration.", new Object[0]);
            }
            cachePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)CACHE, (String)CACHE_NAME_DISTRIBUTABLE)});
            ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
            cacheAddOperation.get(PASSIVATION_STORE).set(PASSIVATION_STORE_NAME);
            for (String alias : ALIASES_ATTR_VALUE) {
                cacheAddOperation.get(ALIASES_ATTR_NAME).add(alias);
            }
            server.executeManagementOperation(cacheAddOperation);
            ServerMigrationLogger.ROOT_LOGGER.infof("Distributable cache added to EJB3 subsystem configuration.", new Object[0]);
        }
    }
}

