/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.subsystem.infinispan;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.wfly10.standalone.WildFly10StandaloneServer;
import org.jboss.migration.wfly10.subsystem.WildFly10Subsystem;
import org.jboss.migration.wfly10.subsystem.WildFly10SubsystemMigrationTask;

public class AddServerCache
implements WildFly10SubsystemMigrationTask {
    public static final AddServerCache INSTANCE = new AddServerCache();
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE_NAME = "server";
    private static final String DEFAULT_CACHE_ATTR_NAME = "default-cache";
    private static final String DEFAULT_CACHE_ATTR_VALUE = "default";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String MODULE_ATTR_VALUE = "org.wildfly.clustering.server";
    private static final String LOCAL_CACHE = "local-cache";
    private static final String LOCAL_CACHE_NAME = "default";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_NAME = "transaction";
    private static final String MODE_ATTR_NAME = "mode";
    private static final String MODE_ATTR_VALUE = "BATCH";

    private AddServerCache() {
    }

    @Override
    public void execute(ModelNode config, WildFly10Subsystem subsystem, WildFly10StandaloneServer server, ServerMigrationContext context) throws IOException {
        if (config == null) {
            return;
        }
        if (!config.hasDefined(CACHE_CONTAINER)) {
            ServerMigrationLogger.ROOT_LOGGER.infof("No Cache container", new Object[0]);
            return;
        }
        if (config.hasDefined(new String[]{CACHE_CONTAINER, CACHE_NAME})) {
            return;
        }
        Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
        PathAddress cachePathAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)subsystem.getName()), PathElement.pathElement((String)CACHE_CONTAINER, (String)CACHE_NAME)});
        ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
        cacheAddOperation.get(DEFAULT_CACHE_ATTR_NAME).set("default");
        cacheAddOperation.get(MODULE_ATTR_NAME).set(MODULE_ATTR_VALUE);
        compositeOperationBuilder.addStep(cacheAddOperation);
        PathAddress localCachePathAddress = cachePathAddress.append(LOCAL_CACHE, "default");
        ModelNode localCacheAddOperation = Util.createAddOperation((PathAddress)localCachePathAddress);
        compositeOperationBuilder.addStep(localCacheAddOperation);
        PathAddress localCacheTransactionPathAddress = localCachePathAddress.append(COMPONENT, COMPONENT_NAME);
        ModelNode localCacheTransactionAddOperation = Util.createAddOperation((PathAddress)localCacheTransactionPathAddress);
        localCacheTransactionAddOperation.get(MODE_ATTR_NAME).set(MODE_ATTR_VALUE);
        compositeOperationBuilder.addStep(localCacheTransactionAddOperation);
        server.executeManagementOperation(compositeOperationBuilder.build().getOperation());
        ServerMigrationLogger.ROOT_LOGGER.infof("Server cache added to Infinispan subsystem configuration.", new Object[0]);
    }
}

