/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.eap;

import java.util.ServiceLoader;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.eap.EAP7ServerMigration;

public class EAP7ServerMigrations {
    private static final ServiceLoader<EAP7ServerMigration> SERVICE_LOADER = ServiceLoader.load(EAP7ServerMigration.class);

    private EAP7ServerMigrations() {
    }

    static EAP7ServerMigration getMigrationFrom(Server sourceServer) {
        ServerMigrationLogger.ROOT_LOGGER.debugf("Retrieving server migration for source %s", sourceServer.getClass());
        for (EAP7ServerMigration serverMigration : SERVICE_LOADER) {
            if (!serverMigration.getSourceType().isInstance(sourceServer)) continue;
            ServerMigrationLogger.ROOT_LOGGER.debugf("Found server migration for source %s: %s", sourceServer.getClass(), serverMigration.getClass());
            return serverMigration;
        }
        ServerMigrationLogger.ROOT_LOGGER.debugf("Failed to retrieve server migration for source %s", sourceServer.getClass());
        return null;
    }
}

