/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.ParameterCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.auth.client.SetCallbackHandlerAuthenticationConfiguration;

class SetParameterSpecAuthenticationConfiguration
extends AuthenticationConfiguration {
    private final AlgorithmParameterSpec parameterSpec;

    SetParameterSpecAuthenticationConfiguration(AuthenticationConfiguration parent, AlgorithmParameterSpec parameterSpec) {
        super(parent.without(SetCallbackHandlerAuthenticationConfiguration.class));
        this.parameterSpec = parameterSpec;
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws UnsupportedCallbackException, IOException {
        ParameterCallback parameterCallback;
        Callback callback = callbacks[index];
        if (callback instanceof ParameterCallback && (parameterCallback = (ParameterCallback)callback).getParameterSpec() == null && parameterCallback.isParameterSupported(this.parameterSpec)) {
            parameterCallback.setParameterSpec(this.parameterSpec);
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetParameterSpecAuthenticationConfiguration(newParent, this.parameterSpec);
    }
}

