/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.sasl.util.SaslMechanismInformation;

class SetPasswordCallbackHandlerAuthenticationConfiguration
extends AuthenticationConfiguration
implements AuthenticationConfiguration.CredentialSetting {
    private final CallbackHandler callbackHandler;

    SetPasswordCallbackHandlerAuthenticationConfiguration(AuthenticationConfiguration parent, CallbackHandler callbackHandler) {
        super(parent.without(AuthenticationConfiguration.CredentialSetting.class));
        this.callbackHandler = callbackHandler;
    }

    @Override
    void handleCallbacks(AuthenticationConfiguration config, Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ArrayList<Callback> list = null;
        for (Callback callback : callbacks) {
            if (!(callback instanceof PasswordCallback) && !(callback instanceof CredentialCallback)) continue;
            if (list == null) {
                list = new ArrayList<Callback>(callbacks.length);
            }
            list.add(callback);
        }
        if (list != null) {
            this.callbackHandler.handle(list.toArray(new Callback[list.size()]));
        }
        super.handleCallbacks(config, callbacks);
    }

    @Override
    void handleCallback(Callback[] callbacks, int index) throws IOException, UnsupportedCallbackException {
        Callback callback = callbacks[index];
        if (callback instanceof PasswordCallback || callback instanceof CredentialCallback) {
            return;
        }
        super.handleCallback(callbacks, index);
    }

    @Override
    boolean filterOneSaslMechanism(String mechanismName) {
        Set<Class<? extends Credential>> types = SaslMechanismInformation.getSupportedClientCredentialTypes(mechanismName);
        return types == null || types.contains(PasswordCredential.class) || super.filterOneSaslMechanism(mechanismName);
    }

    @Override
    AuthenticationConfiguration reparent(AuthenticationConfiguration newParent) {
        return new SetPasswordCallbackHandlerAuthenticationConfiguration(newParent, this.callbackHandler);
    }
}

