/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.impl;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;

abstract class UsernamePasswordAuthenticationMechanism
implements HttpServerAuthenticationMechanism {
    protected final CallbackHandler callbackHandler;

    protected UsernamePasswordAuthenticationMechanism(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    protected boolean authenticate(String realmName, String username, char[] password) throws HttpAuthenticationException {
        RealmCallback realmCallback = realmName != null ? new RealmCallback("User realm", realmName) : null;
        NameCallback nameCallback = new NameCallback("Remote Authentication Name", username);
        nameCallback.setName(username);
        PasswordGuessEvidence evidence = new PasswordGuessEvidence(password);
        EvidenceVerifyCallback evidenceVerifyCallback = new EvidenceVerifyCallback(evidence);
        try {
            Callback[] callbacks = realmCallback != null ? new Callback[]{realmCallback, nameCallback, evidenceVerifyCallback} : new Callback[]{nameCallback, evidenceVerifyCallback};
            this.callbackHandler.handle(callbacks);
            boolean bl = evidenceVerifyCallback.isVerified();
            return bl;
        }
        catch (UnsupportedCallbackException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new HttpAuthenticationException(e);
        }
        finally {
            evidence.destroy();
        }
    }

    protected boolean authorize(String username) throws HttpAuthenticationException {
        AuthorizeCallback authorizeCallback = new AuthorizeCallback(username, username);
        try {
            this.callbackHandler.handle(new Callback[]{authorizeCallback});
            return authorizeCallback.isAuthorized();
        }
        catch (UnsupportedCallbackException e) {
            return false;
        }
        catch (IOException e) {
            throw new HttpAuthenticationException(e);
        }
    }

    protected void succeed() throws IOException, UnsupportedCallbackException {
        this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED});
    }

    protected void fail() throws IOException, UnsupportedCallbackException {
        this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.FAILED});
    }
}

