/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.logging;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Set;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.domain.management.security.password.PasswordValidationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYDM", length=4)
public interface DomainManagementLogger
extends BasicLogger {
    public static final DomainManagementLogger ROOT_LOGGER = (DomainManagementLogger)Logger.getMessageLogger(DomainManagementLogger.class, (String)"org.jboss.as.domain.management");
    public static final DomainManagementLogger SECURITY_LOGGER = (DomainManagementLogger)Logger.getMessageLogger(DomainManagementLogger.class, (String)"org.jboss.as.domain.management.security");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="Properties file defined with default user and password, this will be easy to guess.")
    public void userAndPasswordWarning();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Whitespace has been trimmed from the Base64 representation of the secret identity.")
    public void whitespaceTrimmed();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=3, value="The attribute 'password' is deprecated, 'keystore-password' should be used instead.")
    public void passwordAttributeDeprecated();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="The realm name of the defined security realm '%s' does not match the realm name within the properties file '%s'.")
    public void realmMisMatch(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=5, value="Failed to retrieving groups from the LDAP provider.")
    public void failedRetrieveLdapGroups(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=6, value="Failed to retrieving matching groups from the pattern, check the regular expression for pattern attribute.")
    public void failedRetrieveMatchingLdapGroups(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=7, value="Failed to retrieve matching groups from the groups, check the regular expression for groups attribute.")
    public void failedRetrieveMatchingGroups();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Failed to retrieve attribute %s from search result.")
    public void failedRetrieveLdapAttribute(String var1);

    @Message(id=9, value="Unable to perform verification")
    public IOException cannotPerformVerification(@Cause Throwable var1);

    @Message(id=10, value="Invalid Realm '%s' expected '%s'")
    public IllegalStateException invalidRealm(String var1, String var2);

    @Message(id=11, value="Can't follow referral for authentication: %s")
    public NamingException nameNotFound(String var1);

    @Message(id=13, value="No username provided.")
    public IOException noUsername();

    @Message(id=14, value="No password to verify.")
    public IOException noPassword();

    @Message(id=15, value="One of '%s' or '%s' required.")
    public IllegalArgumentException oneOfRequired(String var1, String var2);

    @Message(id=16, value="Realm choice not currently supported.")
    public UnsupportedCallbackException realmNotSupported(@Param Callback var1);

    @Message(id=17, value="Unable to load properties")
    public StartException unableToLoadProperties(@Cause Throwable var1);

    @Message(id=18, value="Unable to start service")
    public StartException unableToStart(@Cause Throwable var1);

    @Message(id=19, value="User '%s' not found.")
    public String userNotFound(String var1);

    @Message(id=20, value="User '%s' not found in directory.")
    public NamingException userNotFoundInDirectory(String var1);

    @Message(id=21, value="No java.io.Console available to interact with user.")
    public IllegalStateException noConsoleAvailable();

    @Message(id=23, value="No %s files found.")
    public String propertiesFileNotFound(String var1);

    @Message(id=0, value="Enter the details of the new user to add.")
    public String enterNewUserDetails();

    @Message(id=0, value="Realm (%s)")
    public String realmPrompt(String var1);

    @Message(id=0, value="Username")
    public String usernamePrompt();

    @Message(id=0, value="Username (%s)")
    public String usernamePrompt(String var1);

    @Message(id=24, value="No Username entered, exiting.")
    public String noUsernameExiting();

    @Message(id=0, value="Password")
    public String passwordPrompt();

    @Message(id=25, value="No Password entered, exiting.")
    public String noPasswordExiting();

    @Message(id=0, value="Re-enter Password")
    public String passwordConfirmationPrompt();

    @Message(id=26, value="The passwords do not match.")
    public String passwordMisMatch();

    @Message(id=28, value="Username must be alphanumeric with the exception of the following accepted symbols (%s)")
    public String usernameNotAlphaNumeric(String var1);

    @Message(id=0, value="About to add user '%s' for realm '%s'")
    public String aboutToAddUser(String var1, String var2);

    @Message(id=0, value="Is this correct")
    public String isCorrectPrompt();

    @Message(id=0, value="The username '%s' is easy to guess")
    public String usernameEasyToGuess(String var1);

    @Message(id=0, value="Are you sure you want to add user '%s' yes/no?")
    public String sureToAddUser(String var1);

    @Message(id=29, value="Invalid response. (Valid responses are %s and %s)")
    public String invalidConfirmationResponse(String var1, String var2);

    @Message(id=0, value="Added user '%s' to file '%s'")
    public String addedUser(String var1, String var2);

    @Message(id=30, value="Unable to add user to %s due to error %s")
    public String unableToAddUser(String var1, String var2);

    @Message(id=31, value="Unable to add load users from %s due to error %s")
    public String unableToLoadUsers(String var1, String var2);

    @Message(id=0, value="Error")
    public String errorHeader();

    @Message(id=0, value="Is this new user going to be used for one AS process to connect to another AS process? %ne.g. for a slave host controller connecting to the master or for a Remoting connection for server to server EJB calls.")
    public String serverUser();

    @Message(id=0, value="yes/no?")
    public String yesNo();

    @Message(id=0, value="To represent the user add the following to the server-identities definition <secret value=\"%s\" />")
    public String secretElement(String var1);

    @Message(id=33, value="Configuration for security realm '%s' includes multiple username/password based authentication mechanisms (%s). Only one is allowed")
    public OperationFailedException multipleAuthenticationMechanismsDefined(String var1, Set<String> var2);

    @Message(id=34, value="One of '%s' or '%s' required.")
    public OperationFailedException operationFailedOneOfRequired(String var1, String var2);

    @Message(id=35, value="Only one of '%s' or '%s' is required.")
    public OperationFailedException operationFailedOnlyOneOfRequired(String var1, String var2);

    @Message(id=37, value="No security context has been established.")
    public String noSecurityContextEstablished();

    @Message(id=0, value="What type of user do you wish to add? %n a) Management User (mgmt-users.properties) %n b) Application User (application-users.properties)")
    public String filePrompt();

    @Message(id=0, value="What groups do you want this user to belong to? (Please enter a comma separated list, or leave blank for none)")
    public String groupsPrompt();

    @Message(id=0, value="Added user '%s' with groups %s to file '%s'")
    public String addedGroups(String var1, String var2, String var3);

    @Message(id=39, value="Invalid response. (Valid responses are A, a, B, or b)")
    public String invalidChoiceResponse();

    @Message(id=0, value="User '%s' already exists and is enabled, would you like to... %n a) Update the existing user password and roles %n b) Disable the existing user %n c) Type a new username")
    public String aboutToUpdateEnabledUser(String var1);

    @Message(id=0, value="User '%s' already exists and is disabled, would you like to... %n a) Update the existing user password and roles %n b) Enable the existing user %n c) Type a new username")
    public String aboutToUpdateDisabledUser(String var1);

    @Message(id=0, value="Updated user '%s' to file '%s'")
    public String updateUser(String var1, String var2);

    @Message(id=40, value="Unable to update user to %s due to error %s")
    public String unableToUpdateUser(String var1, String var2);

    @Message(id=0, value="Updated user '%s' with groups %s to file '%s'")
    public String updatedGroups(String var1, String var2, String var3);

    @Message(id=41, value="The user '%s' is not allowed in a local authentication.")
    public IOException invalidLocalUser(String var1);

    @Message(id=42, value="Multiple CallbackHandlerServices for the same mechanism (%s)")
    public StartException multipleCallbackHandlerForMechanism(String var1);

    @Message(id=43, value="No CallbackHandler available for mechanism %s in realm %s")
    public IllegalStateException noCallbackHandlerForMechanism(String var1, String var2);

    @Message(id=44, value="No plug in providers found for module name %s")
    public IllegalArgumentException noPlugInProvidersLoaded(String var1);

    @Message(id=45, value="Unable to load plug-in for module %s due to error (%s)")
    public IllegalArgumentException unableToLoadPlugInProviders(String var1, String var2);

    @Message(id=46, value="No authentication plug-in found for name %s")
    public IllegalArgumentException noAuthenticationPlugInFound(String var1);

    @Message(id=47, value="Unable to initialise plug-in %s due to error %s")
    public IllegalStateException unableToInitialisePlugIn(String var1, String var2);

    @Message(id=48, value="Password is not strong enough, it is '%s'. It should be at least '%s'.")
    public String passwordNotStrongEnough(String var1, String var2);

    @Message(id=49, value="Password must not be equal to '%s', this value is restricted.")
    public PasswordValidationException passwordMustNotBeEqual(String var1);

    @Message(id=50, value="Password must have at least %d digit.")
    public String passwordMustHaveDigit(int var1);

    @Message(id=51, value="Password must have at least %s non-alphanumeric symbol.")
    public String passwordMustHaveSymbol(int var1);

    @Message(id=52, value="Password must have at least %d alphanumeric character.")
    public String passwordMustHaveAlpha(int var1);

    @Message(id=53, value="Password must have at least %s characters!")
    public PasswordValidationException passwordNotLongEnough(int var1);

    @Message(id=54, value="Unable to load key trust file.")
    public IllegalStateException unableToLoadKeyTrustFile(@Cause Throwable var1);

    @Message(id=55, value="Unable to operate on trust store.")
    public IllegalStateException unableToOperateOnTrustStore(@Cause GeneralSecurityException var1);

    @Message(id=56, value="Unable to create delegate trust manager.")
    public IllegalStateException unableToCreateDelegateTrustManager();

    @Message(id=57, value="The syslog-handler can only contain one protocol %s")
    public XMLStreamException onlyOneSyslogHandlerProtocol(Location var1);

    @Message(id=58, value="There is no handler called '%s'")
    public IllegalStateException noHandlerCalled(String var1);

    @Message(id=59, value="There is already a protocol configured for the syslog handler at %s")
    public OperationFailedException sysLogProtocolAlreadyConfigured(PathAddress var1);

    @Message(id=60, value="No syslog protocol was given")
    public OperationFailedException noSyslogProtocol();

    @Message(id=61, value="There is no formatter called '%s'")
    public OperationFailedException noFormatterCalled(String var1);

    @Message(id=62, value="Can not remove formatter, it is still referenced by the handler '%s'")
    public OperationFailedException cannotRemoveReferencedFormatter(PathElement var1);

    @Message(id=63, value="Handler names must be unique. There is already a handler called '%s' at %s")
    public OperationFailedException handlerAlreadyExists(String var1, PathAddress var2);

    @Message(id=64, value="Different realm names detected '%s', '%s' reading user property files, all realms must be equal.")
    public String multipleRealmsDetected(String var1, String var2);

    @Message(id=65, value="The user supplied realm name '%s' does not match the realm name discovered from the property file(s) '%s'.")
    public String userRealmNotMatchDiscovered(String var1, String var2);

    @Message(id=66, value="A group properties file '%s' has been specified, however no user properties has been specified.")
    public String groupPropertiesButNoUserProperties(String var1);

    @Message(id=67, value="A realm name must be specified.")
    public String realmMustBeSpecified();

    @Message(id=68, value="The current operation(s) would result in role based access control being enabled but leave it impossible for authenticated users to be assigned roles.")
    public OperationFailedException inconsistentRbacConfiguration();

    @Message(id=69, value="The runtime role mapping configuration is inconsistent, the server must be restarted.")
    public OperationFailedException inconsistentRbacRuntimeState();

    @Message(id=70, value="Invalid response. (Valid responses are A, a, B, b, C or c)")
    public String invalidChoiceUpdateUserResponse();

    @Message(id=71, value="Role '%s' already contains an %s for type=%s, name=%s, realm=%s.")
    public OperationFailedException duplicateIncludeExclude(String var1, String var2, String var3, String var4, String var5);

    @Message(id=72, value="Configuration for security realm '%s' includes multiple authorization configurations (%s). Only one is allowed")
    public OperationFailedException multipleAuthorizationConfigurationsDefined(String var1, Set<String> var2);

    @Message(id=73, value="Configuration for security realm '%s' includes multiple username-to-dn resources within the authorization=ldap resource (%s). Only one is allowed")
    public OperationFailedException multipleUsernameToDnConfigurationsDefined(String var1, Set<String> var2);

    @Message(id=74, value="Configuration for security realm '%s' does not contain any group-search resource within the authorization=ldap resource.")
    public OperationFailedException noGroupSearchDefined(String var1);

    @Message(id=75, value="Configuration for security realm '%s' includes multiple group-search resources within the authorization=ldap resource (%s). Only one is allowed")
    public OperationFailedException multipleGroupSearchConfigurationsDefined(String var1, Set<String> var2);

    @Message(id=76, value="The role name '%s' is not a valid standard role.")
    public OperationFailedException invalidRoleName(String var1);

    @Message(id=77, value="The role name '%s' is not a valid standard role and is not a host scoped role or a server group scoped role.")
    public OperationFailedException invalidRoleNameDomain(String var1);

    @Message(id=78, value="The scoped role '%s' can not be removed as a role mapping still exists.")
    public OperationFailedException roleMappingRemaining(String var1);

    @Message(id=79, value="A %s already exists with name '%s'")
    public OperationFailedException duplicateScopedRole(String var1, String var2);

    @Message(id=80, value="The name '%s' conflicts with the standard role name of '%s' - comparison is case insensitive.")
    public OperationFailedException scopedRoleStandardName(String var1, String var2);

    @Message(id=81, value="The base-role '%s' is not one of the standard roles for the current authorization provider.")
    public OperationFailedException badBaseRole(String var1);

    @Message(id=82, value="The password must be different from the username")
    public PasswordValidationException passwordUsernameMatchError();

    @Message(id=83, value="The KeyStore %s does not contain any keys.")
    public StartException noKey(String var1);

    @Message(id=84, value="The alias specified '%s' is not a Key, valid aliases are %s")
    public StartException aliasNotKey(String var1, String var2);

    @Message(id=85, value="The alias specified '%s' does not exist in the KeyStore, valid aliases are %s")
    public StartException aliasNotFound(String var1, String var2);

    @Message(id=86, value="The KeyStore can not be found at %s")
    public StartException keyStoreNotFound(String var1);

    @Message(id=87, value="Configuration for security realm '%s' includes multiple cache definitions at the same position in the hierarchy. Only one is allowed")
    public OperationFailedException multipleCacheConfigurationsDefined(String var1);

    @Message(id=88, value="Unable to load username for supplied username '%s'")
    public NamingException usernameNotLoaded(String var1);

    @Message(id=89, value="No operation was found that has been holding the operation execution write lock for long than [%d] seconds")
    public OperationFailedException noNonProgressingOperationFound(long var1);

    @Message(id=90, value="Invalid Keytab path")
    public StartException invalidKeytab(@Cause Exception var1);

    @Message(id=91, value="logout has already been called on this SubjectIdentity.")
    public IllegalStateException subjectIdentityLoggedOut();

    @Message(id=92, value="Unable to obtain Kerberos TGT")
    public OperationFailedException unableToObtainTGT(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=93, value="Login failed using Keytab for principal '%s' to handle request for host '%s'")
    public void keytabLoginFailed(String var1, String var2, @Cause LoginException var3);

    @Message(id=94, value="Kerberos is enabled for authentication on security realm '%s' but no Keytab has been added to the server-identity.")
    public OperationFailedException kerberosWithoutKeytab(String var1);

    @Message(id=95, value="No cipher suites in common, supported=(%s), requested=(%s)")
    public StartException noCipherSuitesInCommon(String var1, String var2);

    @Message(id=96, value="No protocols in common, supported=(%s), requested=(%s)")
    public StartException noProtocolsInCommon(String var1, String var2);

    @Message(id=97, value="Password should not be equal to '%s', this value is restricted.")
    public PasswordValidationException passwordShouldNotBeEqual(String var1);

    @Message(id=98, value="The password should be different from the username")
    public PasswordValidationException passwordUsernameShouldNotMatch();

    @Message(id=99, value="Password should have at least %s characters!")
    public PasswordValidationException passwordShouldHaveXCharacters(int var1);

    @Message(id=100, value="Password should have at least %d alphanumeric character.")
    public String passwordShouldHaveAlpha(int var1);

    @Message(id=101, value="Password should have at least %d digit.")
    public String passwordShouldHaveDigit(int var1);

    @Message(id=102, value="Password should have at least %s non-alphanumeric symbol.")
    public String passwordShouldHaveSymbol(int var1);

    @Message(id=103, value="Invalid size %s")
    public OperationFailedException invalidSize(String var1);

    @Message(id=104, value="The suffix (%s) can not contain seconds or milliseconds.")
    public OperationFailedException suffixContainsMillis(String var1);

    @Message(id=105, value="The suffix (%s) is invalid. A suffix must be a valid date format.")
    public OperationFailedException invalidSuffix(String var1);

    @Message(id=106, value="File permissions problems found while attempting to update %s file.")
    public String filePermissionsProblemsFound(String var1);

    @Message(id=107, value="Operation '%s' has been holding the operation execution write lock for longer than [%d] seconds, but it is part of the rollout of a domain-wide operation with domain-uuid '%s' that has other operations that are alsonot progressing. Their ids are: %s. Cancellation of the operation on the master host controller is recommended.")
    public OperationFailedException domainRolloutNotProgressing(String var1, long var2, String var4, Collection var5);

    @Message(id=108, value="Unsupported resource '%s'")
    public IllegalStateException unsupportedResource(String var1);

    @Message(id=109, value="The Keytab file '%s' does not exist.")
    public StartException keyTabFileNotFound(String var1);

    @Message(id=110, value="Unable to load a simple name for group '%s'")
    public NamingException unableToLoadSimpleNameForGroup(String var1);

    @Message(id=111, value="Keystore %s not found, it will be auto generated on first use with a self signed certificate for host %s")
    @LogMessage(level=Logger.Level.WARN)
    public void keystoreWillBeCreated(String var1, String var2);

    @Message(id=112, value="Failed to generate self signed certificate")
    public RuntimeException failedToGenerateSelfSignedCertificate(@Cause Exception var1);

    @Message(id=113, value="Generated self signed certificate at %s. Please note that self signed certificates are not secure, and should only be used for testing purposes. Do not use this self signed certificate in production.\nSHA-1 fingerprint of the generated key is %s\nSHA-256 fingerprint of the generated key is %s")
    @LogMessage(level=Logger.Level.WARN)
    public void keystoreHasBeenCreated(String var1, String var2, String var3);

    @Message(id=114, value="Failed to lazily initialize SSL context")
    public RuntimeException failedToCreateLazyInitSSLContext(@Cause Exception var1);

    @Message(id=115, value="No signature algorithm name given")
    public IllegalArgumentException noSignatureAlgorithmNameGiven();

    @Message(id=116, value="Signature algorithm name \"%s\" is not recognized")
    public IllegalArgumentException unknownSignatureAlgorithmName(String var1);

    @Message(id=117, value="No signing key given")
    public IllegalArgumentException noSigningKeyGiven();

    @Message(id=118, value="Signing key algorithm name \"%s\" is not compatible with signature algorithm name \"%s\"")
    public IllegalArgumentException signingKeyNotCompatWithSig(String var1, String var2);

    @Message(id=119, value="Not-valid-before date of %s is after not-valid-after date of %s")
    public IllegalArgumentException validAfterBeforeValidBefore(ZonedDateTime var1, ZonedDateTime var2);

    @Message(id=120, value="No issuer DN given")
    public IllegalArgumentException noIssuerDnGiven();

    @Message(id=121, value="No public key given")
    public IllegalArgumentException noPublicKeyGiven();

    @Message(id=122, value="Issuer and subject unique ID are only allowed in certificates with version 2 or higher")
    public IllegalArgumentException uniqueIdNotAllowed();

    @Message(id=123, value="X.509 encoding of public key with algorithm \"%s\" failed")
    public IllegalArgumentException invalidKeyForCert(String var1, @Cause Exception var2);

    @Message(id=124, value="Failed to sign certificate")
    public IllegalArgumentException certSigningFailed(@Cause Exception var1);

    @Message(id=125, value="Certificate serial number must be positive")
    public IllegalArgumentException serialNumberTooSmall();

    @Message(id=126, value="Certificate serial number too large (cannot exceed 20 octets)")
    public IllegalArgumentException serialNumberTooLarge();

    @Message(id=127, value="No sequence to end")
    public IllegalStateException noSequenceToEnd();

    @Message(id=128, value="No set to end")
    public IllegalStateException noSetToEnd();

    @Message(id=129, value="No explicitly tagged element to end")
    public IllegalStateException noExplicitlyTaggedElementToEnd();

    @Message(id=130, value="Invalid OID character")
    public IllegalArgumentException asnInvalidOidCharacter();

    @Message(id=131, value="OID must have at least 2 components")
    public IllegalArgumentException asnOidMustHaveAtLeast2Components();

    @Message(id=132, value="Invalid value for first OID component; expected 0, 1, or 2")
    public IllegalArgumentException asnInvalidValueForFirstOidComponent();

    @Message(id=133, value="Invalid value for second OID component; expected a value between 0 and 39 (inclusive)")
    public IllegalArgumentException asnInvalidValueForSecondOidComponent();

    @Message(id=134, value="Invalid length")
    public IllegalArgumentException asnInvalidLength();

    @Message(id=135, value="The resource %s wasn't working properly and has been removed.")
    public String removedOutOfOrderResource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=136, value="Registered OpenSSL provider")
    public void registeredOpenSSLProvider();

    @Message(id=137, value="Unable to create tmp dir for auth tokens as file already exists.")
    public StartException unableToCreateTempDirForAuthTokensFileExists();

    @Message(id=138, value="Unable to create auth dir %s.")
    public StartException unableToCreateAuthDir(String var1);

    @Message(id=0, value="The password must be different from the username")
    public String passwordUsernameMustMatchInfo();

    @Message(id=0, value="The password should be different from the username")
    public String passwordUsernameShouldMatchInfo();

    @Message(id=0, value="The password must not be one of the following restricted values {%s}")
    public String passwordMustNotEqualInfo(String var1);

    @Message(id=0, value="The password should not be one of the following restricted values {%s}")
    public String passwordShouldNotEqualInfo(String var1);

    @Message(id=0, value="%s characters")
    public String passwordLengthInfo(int var1);

    @Message(id=0, value="%d alphabetic character(s)")
    public String passwordMustHaveAlphaInfo(int var1);

    @Message(id=0, value="%d digit(s)")
    public String passwordMustHaveDigitInfo(int var1);

    @Message(id=0, value="%s non-alphanumeric symbol(s)")
    public String passwordMustHaveSymbolInfo(int var1);

    @Message(id=0, value="The password must contain at least %s")
    public String passwordMustContainInfo(String var1);

    @Message(id=0, value="The password should contain at least %s")
    public String passwordShouldContainInfo(String var1);

    @Message(id=0, value="Are you sure you want to use the password entered yes/no?")
    public String sureToSetPassword();

    @Message(id=0, value="The add-user script is a utility for adding new users to the properties files for out-of-the-box authentication. It can be used to manage users in ManagementRealm and ApplicationRealm.")
    public String usageDescription();

    @Message(id=0, value="Usage: ./add-user.sh [args...]%nwhere args include:")
    public String argUsage();

    @Message(id=0, value="If set add an application user instead of a management user")
    public String argApplicationUsers();

    @Message(id=0, value="Define the location of the domain config directory.")
    public String argDomainConfigDirUsers();

    @Message(id=0, value="Define the location of the server config directory.")
    public String argServerConfigDirUsers();

    @Message(id=0, value="The file name of the user properties file which can be an absolute path.")
    public String argUserProperties();

    @Message(id=0, value="The file name of the group properties file which can be an absolute path. (If group properties is specified then user properties MUST also be specified).")
    public String argGroupProperties();

    @Message(id=0, value="Password of the user, this will be checked against the password requirements defined within the add-user.properties configuration")
    public String argPassword();

    @Message(id=0, value="Name of the user")
    public String argUser();

    @Message(id=0, value="Name of the realm used to secure the management interfaces (default is \"ManagementRealm\")")
    public String argRealm();

    @Message(id=0, value="Activate the silent mode (no output to the console)")
    public String argSilent();

    @Message(id=0, value="Comma-separated list of roles for the user.")
    public String argRole();

    @Message(id=0, value="Comma-separated list of groups for the user.")
    public String argGroup();

    @Message(id=0, value="Enable the user")
    public String argEnable();

    @Message(id=0, value="Disable the user")
    public String argDisable();

    @Message(id=0, value="Automatically confirm warning in interactive mode")
    public String argConfirmWarning();

    @Message(id=0, value="If set the secret value will be printed.")
    public String argDisplaySecret();

    @Message(id=0, value="Display this message and exit")
    public String argHelp();

    @Message(id=0, value="yes")
    public String yes();

    @Message(id=0, value="y")
    public String shortYes();

    @Message(id=0, value="no")
    public String no();

    @Message(id=0, value="n")
    public String shortNo();

    @Message(id=0, value="The realm name supplied must match the name used by the server configuration which by default would be '%s'")
    public String alternativeRealm(String var1);

    @Message(id=0, value="Are you sure you want to set the realm to '%s'")
    public String realmConfirmation(String var1);

    @Message(id=0, value="Password requirements are listed below. To modify these restrictions edit the add-user.properties configuration file.")
    public String passwordRequirements();

    @Message(id=0, value="Password recommendations are listed below. To modify these restrictions edit the add-user.properties configuration file.")
    public String passwordRecommendations();

    @Message(id=0, value="Using realm '%s' as specified on the command line.")
    public String userSuppliedRealm(String var1);

    @Message(id=0, value="Using realm '%s' as discovered from the existing property files.")
    public String discoveredRealm(String var1);
}

