/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.core.security.RealmGroup;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.PasswordCredential;
import org.jboss.as.domain.management.security.SubjectCallback;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.security.SimpleGroup;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.evidence.PasswordGuessEvidence;

public class JaasCallbackHandler
implements Service<CallbackHandlerService>,
CallbackHandlerService,
CallbackHandler {
    private static final String SERVICE_SUFFIX = "jaas";
    private static final Map<String, String> configurationOptions;
    private final String realm;
    private final String name;
    private final boolean assignGroups;
    private final InjectedValue<ServerSecurityManager> securityManagerValue = new InjectedValue();

    public JaasCallbackHandler(String realm, String name, boolean assignGroups) {
        this.realm = realm;
        this.name = name;
        this.assignGroups = assignGroups;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return AuthMechanism.PLAIN;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        return configurationOptions;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        return this;
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return null;
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (callbacks.length == 1 && callbacks[0] instanceof AuthorizeCallback) {
            AuthorizeCallback acb = (AuthorizeCallback)callbacks[0];
            boolean authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
            if (!authorized) {
                DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
            }
            acb.setAuthorized(authorized);
            return;
        }
        NameCallback nameCallBack = null;
        EvidenceVerifyCallback evidenceVerifyCallback = null;
        SubjectCallback subjectCallback = null;
        for (Callback current : callbacks) {
            if (current instanceof NameCallback) {
                nameCallBack = (NameCallback)current;
                continue;
            }
            if (current instanceof RealmCallback) continue;
            if (current instanceof EvidenceVerifyCallback) {
                evidenceVerifyCallback = (EvidenceVerifyCallback)current;
                continue;
            }
            if (!(current instanceof SubjectCallback)) throw new UnsupportedCallbackException(current);
            subjectCallback = (SubjectCallback)current;
        }
        if (nameCallBack == null) {
            DomainManagementLogger.SECURITY_LOGGER.trace("No username supplied in Callbacks.");
            throw DomainManagementLogger.ROOT_LOGGER.noUsername();
        }
        final String userName = nameCallBack.getDefaultName();
        if (userName == null || userName.length() == 0) {
            DomainManagementLogger.SECURITY_LOGGER.trace("NameCallback either has no username or is 0 length.");
            throw DomainManagementLogger.ROOT_LOGGER.noUsername();
        }
        if (evidenceVerifyCallback == null || evidenceVerifyCallback.getEvidence() == null) {
            DomainManagementLogger.SECURITY_LOGGER.trace("No password to verify.");
            throw DomainManagementLogger.ROOT_LOGGER.noPassword();
        }
        if (!(evidenceVerifyCallback.getEvidence() instanceof PasswordGuessEvidence)) {
            DomainManagementLogger.SECURITY_LOGGER.trace("No password to verify.");
            throw DomainManagementLogger.ROOT_LOGGER.noPassword();
        }
        final char[] password = ((PasswordGuessEvidence)evidenceVerifyCallback.getEvidence()).getGuess();
        Subject subject = subjectCallback != null && subjectCallback.getSubject() != null ? subjectCallback.getSubject() : new Subject();
        ServerSecurityManager securityManager = (ServerSecurityManager)this.securityManagerValue.getOptionalValue();
        if (securityManager != null) {
            try {
                securityManager.push(this.name, userName, password, subject);
                securityManager.authenticate();
                evidenceVerifyCallback.setVerified(true);
                subject = securityManager.getSubject();
                subject.getPrivateCredentials().add(new PasswordCredential(userName, password));
                if (this.assignGroups) {
                    Set<Principal> prinicpals = subject.getPrincipals();
                    Set<SimpleGroup> groups = subject.getPrincipals(SimpleGroup.class);
                    for (SimpleGroup current : groups) {
                        if (!"Roles".equals(current.getName())) continue;
                        Enumeration members = current.members();
                        while (members.hasMoreElements()) {
                            prinicpals.add((Principal)new RealmGroup(this.realm, ((Principal)members.nextElement()).getName()));
                        }
                    }
                }
                if (subjectCallback == null) return;
                subjectCallback.setSubject(subject);
                return;
            }
            catch (SecurityException e) {
                DomainManagementLogger.SECURITY_LOGGER.debug("Failed to verify password in JAAS callbackhandler " + this.name, e);
                evidenceVerifyCallback.setVerified(false);
                return;
            }
            finally {
                securityManager.pop();
            }
        }
        try {
            LoginContext ctx = new LoginContext(this.name, subject, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (current instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)current;
                            ncb.setName(userName);
                            continue;
                        }
                        if (current instanceof PasswordCallback) {
                            PasswordCallback pcb = (PasswordCallback)current;
                            pcb.setPassword(password);
                            continue;
                        }
                        throw new UnsupportedCallbackException(current);
                    }
                }
            });
            ctx.login();
            evidenceVerifyCallback.setVerified(true);
            subject.getPrivateCredentials().add(new PasswordCredential(userName, password));
            if (this.assignGroups) {
                Set<Principal> prinicpals = subject.getPrincipals();
                Set<SimpleGroup> groups = subject.getPrincipals(SimpleGroup.class);
                for (SimpleGroup current : groups) {
                    if (!"Roles".equals(current.getName())) continue;
                    Enumeration members = current.members();
                    while (members.hasMoreElements()) {
                        prinicpals.add((Principal)new RealmGroup(this.realm, ((Principal)members.nextElement()).getName()));
                    }
                }
            }
            if (subjectCallback == null) return;
            subjectCallback.setSubject(subject);
            return;
        }
        catch (LoginException e) {
            DomainManagementLogger.SECURITY_LOGGER.debug("Login failed in JAAS callbackhandler " + this.name, e);
            evidenceVerifyCallback.setVerified(false);
        }
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public InjectedValue<ServerSecurityManager> getSecurityManagerValue() {
        return this.securityManagerValue;
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    static {
        HashMap<String, String> temp = new HashMap<String, String>(2);
        temp.put("org.jboss.as.domain.management.subject_callback_supported", Boolean.TRUE.toString());
        temp.put("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
        configurationOptions = Collections.unmodifiableMap(temp);
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{JaasCallbackHandler.SERVICE_SUFFIX});
        }
    }
}

