/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.logging.DomainManagementLogger;
import org.jboss.as.domain.management.plugin.AuthenticationPlugIn;
import org.jboss.as.domain.management.plugin.DigestCredential;
import org.jboss.as.domain.management.plugin.Identity;
import org.jboss.as.domain.management.plugin.PasswordCredential;
import org.jboss.as.domain.management.plugin.PlugInConfigurationSupport;
import org.jboss.as.domain.management.plugin.ValidatePasswordCredential;
import org.jboss.as.domain.management.security.AbstractPlugInService;
import org.jboss.as.domain.management.security.CallbackHandlerService;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.EvidenceVerifyCallback;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.sasl.util.UsernamePasswordHashUtil;
import org.wildfly.security.util.ByteIterator;

public class PlugInAuthenticationCallbackHandler
extends AbstractPlugInService
implements Service<CallbackHandlerService>,
CallbackHandlerService {
    private static final String SERVICE_SUFFIX = "plug-in-authentication";
    private static UsernamePasswordHashUtil hashUtil = null;
    private final AuthMechanism mechanism;

    PlugInAuthenticationCallbackHandler(String realmName, String pluginName, Map<String, String> properties, AuthMechanism mechanism) {
        super(realmName, pluginName, properties);
        this.mechanism = mechanism;
    }

    public CallbackHandlerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static UsernamePasswordHashUtil getHashUtil() {
        if (hashUtil == null) {
            try {
                hashUtil = new UsernamePasswordHashUtil();
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException(e);
            }
        }
        return hashUtil;
    }

    @Override
    public AuthMechanism getPreferredMechanism() {
        return this.mechanism;
    }

    @Override
    public Set<AuthMechanism> getSupplementaryMechanisms() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, String> getConfigurationOptions() {
        if (this.mechanism == AuthMechanism.DIGEST) {
            return Collections.singletonMap("org.jboss.as.domain.management.digest.plain_text", Boolean.FALSE.toString());
        }
        return Collections.singletonMap("org.jboss.as.domain.management.verify_password_callback_supported", Boolean.TRUE.toString());
    }

    @Override
    public boolean isReadyForHttpChallenge() {
        return true;
    }

    @Override
    public CallbackHandler getCallbackHandler(Map<String, Object> sharedState) {
        String name = this.getPlugInName();
        final AuthenticationPlugIn<org.jboss.as.domain.management.plugin.Credential> ap = this.getPlugInLoader().loadAuthenticationPlugIn(name);
        if (ap instanceof PlugInConfigurationSupport) {
            PlugInConfigurationSupport pcf = (PlugInConfigurationSupport)((Object)ap);
            try {
                pcf.init(this.getConfiguration(), sharedState);
            }
            catch (IOException e) {
                throw DomainManagementLogger.ROOT_LOGGER.unableToInitialisePlugIn(name, e.getMessage());
            }
        }
        return new CallbackHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                String realmName = PlugInAuthenticationCallbackHandler.this.getRealmName();
                LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
                String userName = null;
                Object credential = null;
                for (Callback current : callbacks) {
                    if (current instanceof AuthorizeCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)current;
                        userName = nameCallback.getDefaultName();
                        Identity identity = ap.loadIdentity(userName, realmName);
                        if (identity == null) continue;
                        credential = identity.getCredential();
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof CredentialCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (current instanceof EvidenceVerifyCallback) {
                        toRespondTo.add(current);
                        continue;
                    }
                    if (!(current instanceof RealmCallback)) throw new UnsupportedCallbackException(current);
                    String realm = ((RealmCallback)current).getDefaultText();
                    if (realmName.equals(realm)) continue;
                    throw DomainManagementLogger.ROOT_LOGGER.invalidRealm(realm, realmName);
                }
                for (Callback current : toRespondTo) {
                    boolean verified;
                    UsernamePasswordHashUtil usernamePasswordHashUtil;
                    if (current instanceof AuthorizeCallback) {
                        AuthorizeCallback acb = (AuthorizeCallback)current;
                        boolean authorized = acb.getAuthenticationID().equals(acb.getAuthorizationID());
                        if (!authorized) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Checking 'AuthorizeCallback', authorized=false, authenticationID=%s, authorizationID=%s.", acb.getAuthenticationID(), acb.getAuthorizationID());
                        }
                        acb.setAuthorized(authorized);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        if (credential == null) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found.", userName);
                            throw new UserNotFoundException(userName);
                        }
                        if (!(credential instanceof PasswordCredential)) throw new UnsupportedCallbackException(current);
                        ((PasswordCallback)current).setPassword(((PasswordCredential)credential).getPassword());
                        continue;
                    }
                    if (current instanceof CredentialCallback) {
                        ClearPasswordSpec passwordSpec;
                        PasswordFactory passwordFactory;
                        if (credential == null) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found.", userName);
                            throw new UserNotFoundException(userName);
                        }
                        CredentialCallback credentialCallback = (CredentialCallback)current;
                        if (!PasswordCredential.class.isAssignableFrom(credentialCallback.getCredentialType())) {
                            throw new UnsupportedCallbackException(current);
                        }
                        String algorithm = credentialCallback.getAlgorithm();
                        if (credential instanceof DigestCredential && (algorithm == null || "digest-md5".equals(algorithm))) {
                            passwordFactory = PlugInAuthenticationCallbackHandler.getPasswordFactory("digest-md5");
                            byte[] hashed = ByteIterator.ofBytes((byte[])((DigestCredential)credential).getHash().getBytes(StandardCharsets.UTF_8)).hexDecode().drain();
                            passwordSpec = new DigestPasswordSpec(userName, realmName, hashed);
                        } else {
                            if (!(credential instanceof PasswordCredential)) throw new UnsupportedCallbackException(current);
                            if (algorithm == null || "clear".equals(algorithm)) {
                                passwordFactory = PlugInAuthenticationCallbackHandler.getPasswordFactory("clear");
                                passwordSpec = new ClearPasswordSpec(((PasswordCredential)credential).getPassword());
                            } else {
                                UsernamePasswordHashUtil hashUtil;
                                if (!"digest-md5".equals(algorithm)) throw new UnsupportedCallbackException(current);
                                passwordFactory = PlugInAuthenticationCallbackHandler.getPasswordFactory("digest-md5");
                                usernamePasswordHashUtil = hashUtil = PlugInAuthenticationCallbackHandler.getHashUtil();
                                synchronized (usernamePasswordHashUtil) {
                                    byte[] hashed = hashUtil.generateHashedHexURP(userName, realmName, ((PasswordCredential)credential).getPassword()).getBytes(StandardCharsets.UTF_8);
                                    passwordSpec = new DigestPasswordSpec(userName, realmName, hashed);
                                }
                            }
                        }
                        try {
                            credentialCallback.setCredential((Credential)credentialCallback.getCredentialType().cast(new org.wildfly.security.credential.PasswordCredential(passwordFactory.generatePassword((KeySpec)passwordSpec))));
                            continue;
                        }
                        catch (InvalidKeySpecException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    if (!(current instanceof EvidenceVerifyCallback)) continue;
                    if (credential == null) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("User '%s' not found.", userName);
                        throw new UserNotFoundException(userName);
                    }
                    EvidenceVerifyCallback evc = (EvidenceVerifyCallback)current;
                    PasswordGuessEvidence evidence = (PasswordGuessEvidence)evc.getEvidence();
                    char[] guess = evidence.getGuess();
                    if (credential instanceof PasswordCredential) {
                        verified = Arrays.equals(((PasswordCredential)credential).getPassword(), guess);
                        if (!verified) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Password verification failed for user '%s'", userName);
                        }
                        evc.setVerified(verified);
                        continue;
                    }
                    if (credential instanceof DigestCredential) {
                        String hash;
                        UsernamePasswordHashUtil hashUtil;
                        usernamePasswordHashUtil = hashUtil = PlugInAuthenticationCallbackHandler.getHashUtil();
                        synchronized (usernamePasswordHashUtil) {
                            hash = hashUtil.generateHashedHexURP(userName, realmName, guess);
                        }
                        String expected = ((DigestCredential)credential).getHash();
                        boolean verified2 = expected.equals(hash);
                        if (!verified2) {
                            DomainManagementLogger.SECURITY_LOGGER.tracef("Digest verification failed for user '%s'", userName);
                        }
                        evc.setVerified(verified2);
                        continue;
                    }
                    if (!(credential instanceof ValidatePasswordCredential)) continue;
                    verified = ((ValidatePasswordCredential)credential).validatePassword(guess);
                    if (!verified) {
                        DomainManagementLogger.SECURITY_LOGGER.tracef("Delegated verification failed for user '%s'", userName);
                    }
                    evc.setVerified(verified);
                }
            }
        };
    }

    @Override
    public SecurityRealm getElytronSecurityRealm() {
        return null;
    }

    private static PasswordFactory getPasswordFactory(String algorithm) {
        try {
            return PasswordFactory.getInstance((String)algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static final class ServiceUtil {
        private ServiceUtil() {
        }

        public static ServiceName createServiceName(String realmName) {
            return SecurityRealm.ServiceUtil.createServiceName(realmName).append(new String[]{PlugInAuthenticationCallbackHandler.SERVICE_SUFFIX});
        }
    }
}

