/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.remoting.AbstractOutboundConnectionService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class LocalOutboundConnectionService
extends AbstractOutboundConnectionService<LocalOutboundConnectionService> {
    public static final ServiceName LOCAL_OUTBOUND_CONNECTION_BASE_SERVICE_NAME = RemotingServices.SUBSYSTEM_ENDPOINT.append(new String[]{"local-outbound-connection"});
    private static final String LOCAL_URI_SCHEME = "local://";
    private final InjectedValue<OutboundSocketBinding> destinationOutboundSocketBindingInjectedValue = new InjectedValue();
    private URI connectionURI;

    public LocalOutboundConnectionService(String connectionName, OptionMap connectionCreationOptions) {
        super(connectionName, connectionCreationOptions);
    }

    @Override
    public IoFuture<Connection> connect() throws IOException {
        URI uri;
        try {
            uri = this.getConnectionURI();
        }
        catch (URISyntaxException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotConnect(e);
        }
        Endpoint endpoint = (Endpoint)this.endpointInjectedValue.getValue();
        return endpoint.connect(uri, null);
    }

    @Override
    public String getProtocol() {
        return "local";
    }

    Injector<OutboundSocketBinding> getDestinationOutboundSocketBindingInjector() {
        return this.destinationOutboundSocketBindingInjectedValue;
    }

    private synchronized URI getConnectionURI() throws IOException, URISyntaxException {
        if (this.connectionURI != null) {
            return this.connectionURI;
        }
        OutboundSocketBinding destinationOutboundSocket = (OutboundSocketBinding)this.destinationOutboundSocketBindingInjectedValue.getValue();
        InetAddress destinationAddress = destinationOutboundSocket.getResolvedDestinationAddress();
        int port = destinationOutboundSocket.getDestinationPort();
        this.connectionURI = new URI(LOCAL_URI_SCHEME + destinationAddress.getHostAddress() + ":" + port);
        return this.connectionURI;
    }

    public LocalOutboundConnectionService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

