/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.security.auth.server.SecurityIdentity;

public class ElytronRunAsHandler
implements HttpHandler {
    private final HttpHandler next;

    public ElytronRunAsHandler(HttpHandler next) {
        this.next = (HttpHandler)Assert.checkNotNullParam((String)"next", (Object)next);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        SecurityIdentity securityIdentity;
        SecurityContext securityContext = exchange.getSecurityContext();
        Account account = securityContext != null ? securityContext.getAuthenticatedAccount() : null;
        SecurityIdentity securityIdentity2 = securityIdentity = account instanceof ElytronAccount ? ((ElytronAccount)account).getSecurityIdentity() : null;
        if (securityIdentity != null) {
            securityIdentity.runAs(() -> {
                this.next.handleRequest(exchange);
                return null;
            });
        } else {
            this.next.handleRequest(exchange);
        }
    }
}

