/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.ExtensionBuilder;
import org.jboss.migration.wfly10.config.task.subsystem.LegacyExtensionBuilder;

public class SupportedExtensions {
    public static final Extension JACORB = new LegacyExtensionBuilder("org.jboss.as.jacorb").subsystem("jacorb").build();
    public static final Extension WEB = new LegacyExtensionBuilder("org.jboss.as.web").subsystem("web").build();
    public static final Extension MESSAGING = new LegacyExtensionBuilder("org.jboss.as.messaging").subsystem("messaging").build();
    public static final Extension INFINISPAN = new ExtensionBuilder("org.jboss.as.clustering.infinispan").addSubsystem("infinispan").build();
    public static final Extension JGROUPS = new ExtensionBuilder("org.jboss.as.clustering.jgroups").addSubsystem("jgroups").build();
    public static final Extension CONNECTOR = new ExtensionBuilder("org.jboss.as.connector").addSubsystem("datasources").addSubsystem("jca").addSubsystem("resource-adapters").build();
    public static final Extension DEPLOYMENT_SCANNER = new ExtensionBuilder("org.jboss.as.deployment-scanner").addSubsystem("deployment-scanner").build();
    public static final Extension EE = new ExtensionBuilder("org.jboss.as.ee").addSubsystem("ee").build();
    public static final Extension EJB3 = new ExtensionBuilder("org.jboss.as.ejb3").addSubsystem("ejb3").build();
    public static final Extension JAXRS = new ExtensionBuilder("org.jboss.as.jaxrs").addSubsystem("jaxrs").build();
    public static final Extension JDR = new ExtensionBuilder("org.jboss.as.jdr").addSubsystem("jdr").build();
    public static final Extension JMX = new ExtensionBuilder("org.jboss.as.jmx").addSubsystem("jmx").build();
    public static final Extension JPA = new ExtensionBuilder("org.jboss.as.jpa").addSubsystem("jpa").build();
    public static final Extension JSF = new ExtensionBuilder("org.jboss.as.jsf").addSubsystem("jsf").build();
    public static final Extension JSR77 = new ExtensionBuilder("org.jboss.as.jsr77").addSubsystem("jsr77").build();
    public static final Extension LOGGING = new ExtensionBuilder("org.jboss.as.logging").addSubsystem("logging").build();
    public static final Extension MAIL = new ExtensionBuilder("org.jboss.as.mail").addSubsystem("mail").build();
    public static final Extension MODCLUSTER = new ExtensionBuilder("org.jboss.as.modcluster").addSubsystem("modcluster").build();
    public static final Extension NAMING = new ExtensionBuilder("org.jboss.as.naming").addSubsystem("naming").build();
    public static final Extension POJO = new ExtensionBuilder("org.jboss.as.pojo").addSubsystem("pojo").build();
    public static final Extension REMOTING = new ExtensionBuilder("org.jboss.as.remoting").addSubsystem("remoting").build();
    public static final Extension SAR = new ExtensionBuilder("org.jboss.as.sar").addSubsystem("sar").build();
    public static final Extension SECURITY = new ExtensionBuilder("org.jboss.as.security").addSubsystem("security").build();
    public static final Extension TRANSACTIONS = new ExtensionBuilder("org.jboss.as.transactions").addSubsystem("transactions").build();
    public static final Extension WEBSERVICES = new ExtensionBuilder("org.jboss.as.webservices").addSubsystem("webservices").build();
    public static final Extension WELD = new ExtensionBuilder("org.jboss.as.weld").addSubsystem("weld").build();
    public static final Extension BATCH_JBERET = new ExtensionBuilder("org.wildfly.extension.batch.jberet").addSubsystem("batch-jberet").build();
    public static final Extension BEAN_VALIDATION = new ExtensionBuilder("org.wildfly.extension.bean-validation").addSubsystem("bean-validation").build();
    public static final Extension SINGLETON = new ExtensionBuilder("org.wildfly.extension.clustering.singleton").addSubsystem("singleton").build();
    public static final Extension IO = new ExtensionBuilder("org.wildfly.extension.io").addSubsystem("io").build();
    public static final Extension MESSAGING_ACTIVEMQ = new ExtensionBuilder("org.wildfly.extension.messaging-activemq").addSubsystem("messaging-activemq").build();
    public static final Extension REQUEST_CONTROLLER = new ExtensionBuilder("org.wildfly.extension.request-controller").addSubsystem("request-controller").build();
    public static final Extension SECURITY_MANAGER = new ExtensionBuilder("org.wildfly.extension.security.manager").addSubsystem("security-manager").build();
    public static final Extension UNDERTOW = new ExtensionBuilder("org.wildfly.extension.undertow").addSubsystem("undertow").build();
    public static final Extension IIOP_OPENJDK = new ExtensionBuilder("org.wildfly.iiop-openjdk").addSubsystem("iiop-openjdk").build();

    public static Set<Extension> all() {
        HashSet<Extension> result = new HashSet<Extension>();
        result.add(CONNECTOR);
        result.add(DEPLOYMENT_SCANNER);
        result.add(EE);
        result.add(EJB3);
        result.add(IIOP_OPENJDK);
        result.add(JACORB);
        result.add(JAXRS);
        result.add(JDR);
        result.add(JGROUPS);
        result.add(JMX);
        result.add(JPA);
        result.add(JSF);
        result.add(JSR77);
        result.add(LOGGING);
        result.add(MAIL);
        result.add(MESSAGING);
        result.add(MODCLUSTER);
        result.add(NAMING);
        result.add(POJO);
        result.add(REMOTING);
        result.add(SAR);
        result.add(SECURITY);
        result.add(TRANSACTIONS);
        result.add(WEBSERVICES);
        result.add(BATCH_JBERET);
        result.add(BEAN_VALIDATION);
        result.add(SINGLETON);
        result.add(INFINISPAN);
        result.add(IO);
        result.add(MESSAGING_ACTIVEMQ);
        result.add(REQUEST_CONTROLLER);
        result.add(SECURITY_MANAGER);
        result.add(UNDERTOW);
        result.add(WEB);
        result.add(WELD);
        return Collections.unmodifiableSet(result);
    }

    public static List<Extension> allExcept(String ... extensionNames) {
        HashSet excludeSet = new HashSet();
        Collections.addAll(excludeSet, extensionNames);
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (Extension extension : SupportedExtensions.all()) {
            if (excludeSet.contains(extension.getName())) continue;
            result.add(extension);
        }
        return Collections.unmodifiableList(result);
    }
}

