/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.infinispan;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class FixHibernateCacheModuleName<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "fix-hibernate-cache-module-name";
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String DEFAULT_NEW_MODULE_NAME = "org.hibernate.infinispan";
    private static final List<String> DEFAULT_LEGACY_MODULE_NAMES = Arrays.asList("org.jboss.as.jpa.hibernate:4", "org.hibernate");

    public FixHibernateCacheModuleName() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration configurationManagement = subsystemResource.getServerConfiguration();
        List legacyModuleNames = taskEnvironment.getPropertyAsList("deprecatedModuleNames", DEFAULT_LEGACY_MODULE_NAMES);
        String newModuleName = taskEnvironment.getPropertyAsString("moduleName", DEFAULT_NEW_MODULE_NAME);
        if (!config.hasDefined(CACHE_CONTAINER)) {
            context.getLogger().infof("No Cache container", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        boolean configUpdated = false;
        for (String cacheName : config.get(CACHE_CONTAINER).keys()) {
            ModelNode cache = config.get(new String[]{CACHE_CONTAINER, cacheName});
            if (!cache.hasDefined(MODULE_ATTR_NAME) || !legacyModuleNames.contains(cache.get(MODULE_ATTR_NAME).asString())) continue;
            ModelNode op = Util.createEmptyOperation((String)"write-attribute", (PathAddress)subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)CACHE_CONTAINER, (String)cacheName)}));
            op.get("name").set(MODULE_ATTR_NAME);
            op.get("value").set(newModuleName);
            configurationManagement.executeManagementOperation(op);
            configUpdated = true;
            context.getLogger().infof("Infinispan subsystem's cache %s 'module' attribute updated to %s.", (Object)cacheName, (Object)newModuleName);
        }
        return configUpdated ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
    }

    public static interface EnvironmentProperties {
        public static final String LEGACY_MODULE_NAMES = "deprecatedModuleNames";
        public static final String NEW_MODULE_NAME = "moduleName";
    }
}

