/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core;

import java.nio.file.Path;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;

public abstract class AbstractServer
implements Server {
    private final String migrationName;
    private final Path baseDir;
    private final ProductInfo productInfo;
    private final MigrationEnvironment migrationEnvironment;

    public AbstractServer(String migrationName, ProductInfo productInfo, Path baseDir, MigrationEnvironment migrationEnvironment) {
        this.migrationName = migrationName;
        this.productInfo = productInfo;
        this.baseDir = baseDir;
        this.migrationEnvironment = migrationEnvironment;
    }

    protected MigrationEnvironment getMigrationEnvironment() {
        return this.migrationEnvironment;
    }

    @Override
    public String getMigrationName() {
        return this.migrationName;
    }

    @Override
    public Path getBaseDir() {
        return this.baseDir;
    }

    @Override
    public ProductInfo getProductInfo() {
        return this.productInfo;
    }

    @Override
    public ServerMigrationTaskResult migrate(Server source, TaskContext context) throws IllegalArgumentException {
        throw ServerMigrationLogger.ROOT_LOGGER.doesNotSupportsMigration(this.productInfo.getName(), this.productInfo.getVersion(), source.getProductInfo().getName(), source.getProductInfo().getVersion());
    }
}

