/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.jboss;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.jboss.ResolvablePath;

public interface AbsolutePathResolver {
    public Path resolveNamedPath(String var1);

    default public Path resolvePath(ResolvablePath resolvablePath) {
        return this.resolvePath(resolvablePath.getPath(), resolvablePath.getRelativeTo());
    }

    default public Path resolvePath(ModelNode modelNode) {
        if (!modelNode.hasDefined("path")) {
            return null;
        }
        Path path = Paths.get(modelNode.get("path").asString(), new String[0]);
        if (!modelNode.hasDefined("relative-to")) {
            return path;
        }
        return this.resolvePath(path, modelNode.get("relative-to").asString());
    }

    default public Path resolvePath(String string) {
        Path namedPath = this.resolveNamedPath(string);
        if (namedPath != null && namedPath.isAbsolute()) {
            return namedPath;
        }
        Path path = Paths.get(string, new String[0]);
        if (path.isAbsolute()) {
            return path;
        }
        return null;
    }

    default public Path resolvePath(Path path, String relativeTo) {
        if (path.isAbsolute()) {
            return path;
        }
        Path relativeToPath = this.resolvePath(relativeTo);
        return relativeToPath != null ? relativeToPath.resolve(path) : null;
    }

    default public Path resolvePath(String path, String relativeTo) {
        return this.resolvePath(Paths.get(path, new String[0]), relativeTo);
    }
}

