/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.report;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.jboss.migration.core.MigrationData;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskExecution;

public class HtmlReportWriter {
    public static HtmlReportWriter INSTANCE = new HtmlReportWriter();

    private HtmlReportWriter() {
    }

    public void toPath(Path path, MigrationData migrationData, ReportTemplate template) throws IOException {
        String s = this.toString(migrationData, template);
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(s, 0, s.length());
        }
    }

    public String toString(MigrationData migrationData, ReportTemplate template) {
        StringBuilder sb = new StringBuilder();
        sb.append(template.header);
        this.appendSummary(migrationData, sb);
        sb.append(template.summaryToEnvironment);
        this.appendEnvironment(migrationData, sb);
        sb.append(template.environmentToTaskSummary);
        this.appendTaskSummary(migrationData, sb);
        sb.append(template.taskSummaryToTaskMap);
        this.appendTaskMap(migrationData, sb);
        sb.append(template.footer);
        return sb.toString();
    }

    private void appendSummary(MigrationData migrationData, StringBuilder sb) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String utcTime = sdf.format(new Date(migrationData.getRootTask().getStartTime()));
        this.appendProperty("Start Time", utcTime, sb);
        this.appendProperty("Source Server", migrationData.getSource().getProductInfo().getName() + ' ' + migrationData.getSource().getProductInfo().getVersion(), sb);
        this.appendProperty("Source Path", migrationData.getSource().getBaseDir(), sb);
        this.appendProperty("Target Server", migrationData.getTarget().getProductInfo().getName() + ' ' + migrationData.getTarget().getProductInfo().getVersion(), sb);
        this.appendProperty("Target Path", migrationData.getTarget().getBaseDir(), sb);
        this.appendProperty("Result", this.getTaskStatus(migrationData.getRootTask().getResult(), (Object)migrationData.getRootTask().getResult().getStatus()), sb);
    }

    private void appendEnvironment(MigrationData migrationData, StringBuilder sb) {
        for (String property : migrationData.getServerMigrationEnvironment().getPropertyNamesReaded()) {
            this.appendProperty(property, migrationData.getServerMigrationEnvironment().getPropertyAsString(property, "null"), sb);
        }
    }

    private void appendTaskSummary(MigrationData migrationData, StringBuilder sb) {
        this.appendProperty("Executed", migrationData.getTasks().size(), sb);
        this.appendProperty("Successful", migrationData.getTaskCount(ServerMigrationTaskResult.Status.SUCCESS), sb);
        this.appendProperty("Skipped", migrationData.getTaskCount(ServerMigrationTaskResult.Status.SKIPPED), sb);
        this.appendProperty("Failed", migrationData.getTaskCount(ServerMigrationTaskResult.Status.FAIL), sb);
    }

    private void appendTaskMap(MigrationData migrationData, StringBuilder sb) {
        int maxTaskPathSizeToDisplaySubtasks = Integer.valueOf(migrationData.getServerMigrationEnvironment().getPropertyAsString("report.html.maxTaskPathSizeToDisplaySubtasks", "4"));
        this.appendTask(migrationData.getRootTask(), sb, maxTaskPathSizeToDisplaySubtasks);
    }

    private void appendTask(TaskExecution task, StringBuilder sb, int maxTaskPathSizeToDisplaySubtasks) {
        String tableClass = task.getTaskPath().size() % 2 == 0 ? "task-map-even" : "task-map-odd";
        sb.append("<table class=\"").append(tableClass).append("\">");
        this.appendTaskHeader(task, sb, maxTaskPathSizeToDisplaySubtasks);
        this.appendTaskDetails(task, sb);
        this.appendTaskSubtasks(task, sb, maxTaskPathSizeToDisplaySubtasks);
        sb.append("</table>");
    }

    private void appendTaskHeader(TaskExecution task, StringBuilder sb, int maxTaskPathSizeToDisplaySubtasks) {
        sb.append("<tr>");
        sb.append("<td class=\"task-map-header\">");
        sb.append("<table class=\"task-header\">");
        sb.append("<tr>");
        sb.append("<td class=\"task-header-name\" id=\"task").append(task.getTaskNumber()).append("\">");
        sb.append("<a class=\"task-display-toggle\" href=\"#task").append(task.getTaskNumber()).append("\" title=\"Show or hide the task details\" onclick=\"toggleDisplayTaskDetails('task").append(task.getTaskNumber()).append("'); return false\">").append(this.getTaskStatus(task.getResult(), task.getTaskName())).append("</a>");
        sb.append("</td>");
        if (!task.getSubtasks().isEmpty()) {
            sb.append("<td class=\"task-header-toggles\">");
            sb.append("<table>");
            sb.append("<tr>");
            if (task.getTaskPath().size() > maxTaskPathSizeToDisplaySubtasks) {
                sb.append("<td class=\"task-display-toggle\" style=\"display: none\" id=\"task").append(task.getTaskNumber()).append("-subtasks-hide\">");
            } else {
                sb.append("<td class=\"task-display-toggle\" id=\"task").append(task.getTaskNumber()).append("-subtasks-hide\">");
            }
            sb.append("<a class=\"task-display-toggle\" title=\"Hide subtasks\" href=\"#task").append(task.getTaskNumber()).append("\" onclick=\"hideSubtasks('task").append(task.getTaskNumber()).append("'); return false\">-</a>");
            sb.append("</td>");
            if (task.getTaskPath().size() > maxTaskPathSizeToDisplaySubtasks) {
                sb.append("<td class=\"task-display-toggle\" id=\"task").append(task.getTaskNumber()).append("-subtasks-show\">");
            } else {
                sb.append("<td class=\"task-display-toggle\" style=\"display: none\" id=\"task").append(task.getTaskNumber()).append("-subtasks-show\">");
            }
            sb.append("<a class=\"task-display-toggle\" title=\"Show subtasks\" href=\"#task").append(task.getTaskNumber()).append("\" onclick=\"showSubtasks('task").append(task.getTaskNumber()).append("'); return false\">+</a>");
            sb.append("</td>");
            sb.append("</tr>");
            sb.append("</table>");
            sb.append("</td>");
        }
        sb.append("</tr>");
        sb.append("</table>");
        sb.append("</td>");
        sb.append("</tr>");
    }

    private void appendTaskDetails(TaskExecution task, StringBuilder sb) {
        boolean first;
        StringBuilder temp;
        Map<String, String> attributes;
        sb.append("<tr>");
        sb.append("<td id=\"task").append(task.getTaskNumber()).append("-details\" style=\"display: none\" class=\"task-map-details\"><table class=\"task-details\">");
        this.appendTaskDetailsProperty("Task Number", task.getTaskNumber(), sb);
        this.appendTaskDetailsProperty("Task Name", task.getTaskName(), sb);
        this.appendTaskDetailsProperty("Task Path", task.getTaskPath(), sb);
        this.appendTaskDetailsProperty("Logger Name", task.getLogger().getName(), sb);
        ServerMigrationTaskResult result = task.getResult();
        this.appendTaskDetailsProperty("Result Status", this.getTaskStatus(result, (Object)result.getStatus()), sb);
        if (result.getStatus() == ServerMigrationTaskResult.Status.FAIL) {
            this.appendTaskDetailsProperty("Fail Reason", result.getFailReason(), sb);
        }
        if ((attributes = result.getAttributes()) != null && !attributes.isEmpty()) {
            temp = new StringBuilder();
            first = true;
            for (Map.Entry entry : attributes.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    temp.append("<br/>");
                }
                temp.append((String)entry.getKey()).append(" = ").append((String)entry.getValue());
            }
            this.appendTaskDetailsProperty("Result Attributes", temp, sb);
        }
        if (!task.getSubtasks().isEmpty()) {
            temp = new StringBuilder();
            first = true;
            for (TaskExecution taskExecution : task.getSubtasks()) {
                if (first) {
                    first = false;
                } else {
                    temp.append("<br/>");
                }
                temp.append("<a onclick=\"showSubtasks('task").append(task.getTaskNumber()).append("'); showTaskDetails('task").append(taskExecution.getTaskNumber()).append("')\" href=\"#task").append(taskExecution.getTaskNumber()).append("\">").append(taskExecution.getTaskName()).append("</a>");
            }
            this.appendTaskDetailsProperty("Subtasks", temp, sb);
        }
        sb.append("</table></td></tr>");
    }

    private void appendTaskSubtasks(TaskExecution task, StringBuilder sb, int maxTaskPathSizeToDisplaySubtasks) {
        List<TaskExecution> subtasks = task.getSubtasks();
        if (!subtasks.isEmpty()) {
            sb.append("<tr>");
            if (task.getTaskPath().size() > maxTaskPathSizeToDisplaySubtasks) {
                sb.append("<td class=\"task-map-subtasks\" style=\"display: none\" id=\"task").append(task.getTaskNumber()).append("-subtasks\">");
            } else {
                sb.append("<td class=\"task-map-subtasks\" id=\"task").append(task.getTaskNumber()).append("-subtasks\">");
            }
            sb.append("<table class=\"task-subtasks\">");
            for (TaskExecution subtask : subtasks) {
                sb.append("<tr>");
                sb.append("<td>");
                this.appendTask(subtask, sb, maxTaskPathSizeToDisplaySubtasks);
                sb.append("</td>");
                sb.append("</tr>");
            }
            sb.append("</table>");
            sb.append("</td>");
            sb.append("</tr>");
        }
    }

    private void appendTaskDetailsProperty(String propertyName, Object propertyValue, StringBuilder sb) {
        sb.append("<tr><td class=\"task-details-property-name\">").append(propertyName).append(":</td><td class=\"task-details-property-value\">").append(propertyValue).append("</td></tr>");
    }

    private void appendProperty(String propertyName, Object propertyValue, StringBuilder sb) {
        sb.append("<tr><td class=\"property-name\">").append(propertyName).append(":</td><td class=\"property-value\">").append(propertyValue).append("</td></tr>");
    }

    private String getTaskStatus(ServerMigrationTaskResult result, Object text) {
        String sb = "<span class=\"task-result-" + (Object)((Object)result.getStatus()) + "\">" + text + "</span>";
        return sb;
    }

    public static class ReportTemplate {
        private final String header;
        private final String summaryToEnvironment;
        private final String environmentToTaskSummary;
        private final String taskSummaryToTaskMap;
        private final String footer;

        private ReportTemplate(String header, String summaryToEnvironment, String environmentToTaskSummary, String taskSummaryToTaskMap, String footer) {
            this.header = header;
            this.summaryToEnvironment = summaryToEnvironment;
            this.environmentToTaskSummary = environmentToTaskSummary;
            this.taskSummaryToTaskMap = taskSummaryToTaskMap;
            this.footer = footer;
        }

        public static ReportTemplate from(Path path) throws IOException {
            return ReportTemplate.from(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
        }

        public static ReportTemplate from(String string) {
            String summaryMarker = "$SUMMARY";
            String environmentMarker = "$ENVIRONMENT";
            String taskSummaryMarker = "$TASK_SUMMARY";
            String taskMapMarker = "$TASK_MAP";
            int summaryIndex = string.indexOf("$SUMMARY");
            String header = string.substring(0, summaryIndex);
            int environmentIndex = string.indexOf("$ENVIRONMENT");
            String summaryToEnvironment = string.substring(summaryIndex + "$SUMMARY".length(), environmentIndex);
            int taskSummaryIndex = string.indexOf("$TASK_SUMMARY");
            String environmentToTaskSummary = string.substring(environmentIndex + "$ENVIRONMENT".length(), taskSummaryIndex);
            int taskMapIndex = string.indexOf("$TASK_MAP");
            String taskSummaryToTaskMap = string.substring(taskSummaryIndex + "$TASK_SUMMARY".length(), taskMapIndex);
            String footer = string.substring(taskMapIndex + "$TASK_MAP".length());
            return new ReportTemplate(header, summaryToEnvironment, environmentToTaskSummary, taskSummaryToTaskMap, footer);
        }
    }
}

