/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.core.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.jboss.migration.core.ServerMigrationContext;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.task.ServerMigrationTask;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskPath;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContextImpl;
import org.jboss.migration.core.task.TaskExecution;

public class TaskExecutionImpl
implements TaskExecution {
    private static final AtomicLong taskCounter = new AtomicLong(0L);
    private final ServerMigrationTask task;
    private final TaskExecutionImpl parent;
    private final List<TaskExecutionImpl> children;
    private final ServerMigrationContext serverMigrationContext;
    private final AtomicLong startTime = new AtomicLong(0L);
    private ServerMigrationTaskResult result;
    private final Logger logger;
    private final long taskNumber;
    private final ServerMigrationTaskPath taskPath;

    public TaskExecutionImpl(ServerMigrationTask task, TaskExecutionImpl parent) {
        this(task, parent, parent.serverMigrationContext);
    }

    public TaskExecutionImpl(ServerMigrationTask task, ServerMigrationContext serverMigrationContext) {
        this(task, null, serverMigrationContext);
    }

    private TaskExecutionImpl(ServerMigrationTask task, TaskExecutionImpl parent, ServerMigrationContext serverMigrationContext) {
        this.task = task;
        this.parent = parent;
        this.serverMigrationContext = serverMigrationContext;
        this.children = new ArrayList<TaskExecutionImpl>();
        this.taskNumber = taskCounter.incrementAndGet();
        this.logger = Logger.getLogger((String)(ServerMigrationTask.class.getName() + '#' + String.valueOf(this.taskNumber)));
        this.taskPath = new ServerMigrationTaskPath(task.getName(), parent != null ? parent.getTaskPath() : null);
    }

    ServerMigrationTask getTask() {
        return this.task;
    }

    @Override
    public long getTaskNumber() {
        return this.taskNumber;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public ServerMigrationTaskName getTaskName() {
        return this.task.getName();
    }

    @Override
    public long getStartTime() {
        return this.startTime.get();
    }

    @Override
    public ServerMigrationTaskPath getTaskPath() {
        return this.taskPath;
    }

    @Override
    public List<TaskExecution> getSubtasks() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public ServerMigrationTaskResult getResult() {
        return this.result;
    }

    @Override
    public ServerMigrationContext getServerMigrationContext() {
        return this.serverMigrationContext;
    }

    TaskExecutionImpl getParent() {
        return this.parent;
    }

    TaskExecutionImpl execute(ServerMigrationTask subtask) throws IllegalStateException, ServerMigrationFailureException {
        if (this.result != null) {
            throw new IllegalStateException();
        }
        if (subtask.getName() == null) {
            throw new IllegalArgumentException("substask " + subtask + " has no name");
        }
        TaskExecutionImpl child = new TaskExecutionImpl(subtask, this);
        this.children.add(child);
        child.run();
        return child;
    }

    public void run() throws IllegalStateException, ServerMigrationFailureException {
        if (!this.startTime.compareAndSet(0L, System.currentTimeMillis())) {
            throw new IllegalStateException("Task " + this.taskPath + " already started");
        }
        this.logger.debugf("Task %s execution starting...", (Object)this.taskPath);
        try {
            this.result = this.task.run(new TaskContextImpl(this));
        }
        catch (ServerMigrationFailureException e) {
            this.result = ServerMigrationTaskResult.fail(e);
            throw e;
        }
        catch (Throwable t) {
            ServerMigrationFailureException e = new ServerMigrationFailureException(t);
            this.result = ServerMigrationTaskResult.fail(e);
            throw e;
        }
        finally {
            this.logger.debugf("Task %s execution completed with result status... %s", (Object)this.taskPath, (Object)this.result);
        }
    }
}

