/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.vdx.wildfly;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.BasicLogger;
import org.projectodd.vdx.core.ErrorPrinter;
import org.projectodd.vdx.core.ErrorType;
import org.projectodd.vdx.core.I18N;
import org.projectodd.vdx.core.Printer;
import org.projectodd.vdx.core.ValidationError;
import org.projectodd.vdx.core.XMLStreamValidationException;
import org.projectodd.vdx.core.schema.SchemaPathGate;
import org.projectodd.vdx.core.schema.SchemaPathPrefixProvider;
import org.projectodd.vdx.wildfly.LoggingPrinter;
import org.projectodd.vdx.wildfly.SchemaDocRelationships;
import org.projectodd.vdx.wildfly.SubsystemStringifier;

public class ErrorReporter {
    private final File document;
    private final File schemaRoot;
    private final BasicLogger logger;

    public ErrorReporter(File document, File schemaRoot, BasicLogger logger) {
        this.document = document;
        this.schemaRoot = schemaRoot;
        this.logger = logger;
    }

    public boolean report(XMLStreamException exception) {
        ValidationError error;
        if (exception instanceof XMLStreamValidationException) {
            error = ((XMLStreamValidationException)exception).getValidationError();
        } else {
            String message = exception.getMessage();
            Matcher dupMatcher = Pattern.compile("^Duplicate attribute '(.+?)'\\.").matcher(message);
            if (dupMatcher.find()) {
                error = ValidationError.from((XMLStreamException)exception, (ErrorType)ErrorType.DUPLICATE_ATTRIBUTE).attribute(QName.valueOf(dupMatcher.group(1)));
            } else {
                error = ValidationError.from((XMLStreamException)exception, (ErrorType)ErrorType.UNKNOWN_ERROR);
                Matcher m = Pattern.compile("Message: \"?([A-Z]+\\d+: )?(.*?)\"?$").matcher(message);
                if (m.find()) {
                    error.fallbackMessage(m.group(2));
                }
            }
        }
        boolean printed = false;
        try {
            File[] schemaFiles = this.schemaRoot.listFiles();
            if (this.schemaRoot.exists() && schemaFiles != null) {
                printed = true;
                List schemas = Arrays.stream(schemaFiles).filter(f -> f.getName().endsWith(".xsd")).map(f -> {
                    try {
                        return f.toURI().toURL();
                    }
                    catch (MalformedURLException ex) {
                        throw new RuntimeException(ex);
                    }
                }).collect(Collectors.toList());
                ArrayList<SubsystemStringifier> stringifiers = new ArrayList<SubsystemStringifier>();
                stringifiers.add(new SubsystemStringifier());
                SchemaDocRelationships rel = new SchemaDocRelationships();
                new ErrorPrinter(this.document.toURI().toURL(), schemas).printer((Printer)new LoggingPrinter(this.logger)).stringifiers(stringifiers).pathGate((SchemaPathGate)rel).prefixProvider((SchemaPathPrefixProvider)rel).print(error);
            } else {
                this.logger.info((Object)I18N.noSchemasAvailable((File)this.schemaRoot));
            }
        }
        catch (Exception ex) {
            printed = false;
            this.logger.info((Object)I18N.failedToPrintError((Throwable)ex));
        }
        return printed;
    }
}

